<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method batchGetStreamInfoByParams(array $params)
 * @method revokeStreamByParams(array $params)
 * @method urgentStreamByParams(array $params)
 * @method evaluateStreamByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建流水
     *
     * @support  string $order_num 外部订单号 [ require true ]
     * @support  int $product_id 拍摄产品云端产品id [ require true ]
     * @support  array $retouch_claim 修片要求 [ require true ]
     * @support  string $take_time 取片时间 [ require true ]
     * @support  array $photo_data 照片信息 [ require true ]
     * @support  string $photography_note 摄影备注 [ require true ]
     * @support  string $retouch_note 修片备注 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function createStream () {
        return self::getClass()->createStream();
    }

    /**
     * 获取流水单详情
     *
     * @param  int $stream_id 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (int $stream_id) {
        return self::getClass()->getStreamInfo([
            "stream_id" => $stream_id,
        ]);
    }

    /**
     * 批量获取流水单信息
     *
     * @param  array $stream_nums 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfo (array $stream_nums) {
        return self::getClass()->batchGetStreamInfo([
            "stream_nums" => $stream_nums,
        ]);
    }

    /**
     * 撤回流水单
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function revokeStream (string $stream_num) {
        return self::getClass()->revokeStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 加急流水单
     *
     * @param  string $stream_num 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function urgentStream (string $stream_num) {
        return self::getClass()->urgentStream([
            "stream_num" => $stream_num,
        ]);
    }

    /**
     * 门店评价流水
     *
     * @support  string $stream_num 流水号 [ require true ]
     * @support  int $star 星级 [Original type uint] [ require true ]
     * @support  string $note 评语 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function evaluateStream () {
        return self::getClass()->evaluateStream();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}