<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method batchGetOrderInfoByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method urgentOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @param  string $external_num 外部订单号 [ require true ]
     * @support  int $photographer_org_id 摄影机构id [ require true ]
     * @support  string $store_name 门店名称 
     * @support  string $photographer 摄影师 
     * @support  bool $dresser_note 化妆师备注 
     * @support  bool $order_note 订单备注 
     * @throws  \Exception
     * @return  int
     */
    public static function createOrder (string $external_num) {
        return self::getClass()->createOrder([
            "external_num" => $external_num,
        ]);
    }

    /**
     * 批量获取订单信息
     *
     * @param  array $external_nums 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetOrderInfo (array $external_nums) {
        return self::getClass()->batchGetOrderInfo([
            "external_nums" => $external_nums,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  string $external_num 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (string $external_num) {
        return self::getClass()->getOrderInfo([
            "external_num" => $external_num,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  string $external_num 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (string $external_num) {
        return self::getClass()->closeOrder([
            "external_num" => $external_num,
        ]);
    }

    /**
     * 加急订单
     *
     * @param  string $order_num 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function urgentOrder (string $order_num) {
        return self::getClass()->urgentOrder([
            "order_num" => $order_num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}