<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method batchGetStreamInfoByParams(array $params)
 * @method revokeStreamByParams(array $params)
 * @method urgentStreamByParams(array $params)
 * @method evaluateStreamByParams(array $params)
 */
class Stream {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建流水
     *
     * @support  string $orderNum 外部订单号 [ require true ]
     * @support  int $productId 拍摄产品云端产品id [ require true ]
     * @support  array $retouchClaim 修片要求 [ require true ]
     * @support  string $takeTime 取片时间 [ require true ]
     * @support  array $photoData 照片信息 [ require true ]
     * @support  string $photographyNote 摄影备注 [ require true ]
     * @support  string $retouchNote 摄影备注 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function createStream () {
        return self::getClass()->createStream();
    }

    /**
     * 获取流水单详情
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (string $streamNum) {
        return self::getClass()->getStreamInfo([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 批量获取流水单信息
     *
     * @param  array $streamNums 流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetStreamInfo (array $streamNums) {
        return self::getClass()->batchGetStreamInfo([
            "streamNums" => $streamNums,
        ]);
    }

    /**
     * 撤回流水单
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function revokeStream (string $streamNum) {
        return self::getClass()->revokeStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 加急流水单
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function urgentStream (string $streamNum) {
        return self::getClass()->urgentStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 门店评价流水
     *
     * @param  string $streamNum 流水号 [ require true ]
     * @support  int $storeEvaluateStar 星级 [Original type uint] [ require true ]
     * @support  string $storeEvaluateReason 评语 [ require true ]
     * @support  string $watcherName 看片师姓名 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function evaluateStream (string $streamNum) {
        return self::getClass()->evaluateStream([
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Stream');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}