<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHourGlassListByParams(array $params)
 * @method getHourGlassInfoByParams(array $params)
 * @method enableHourGlassGlobalStateByParams(array $params)
 * @method disableHourGlassGlobalStateByParams(array $params)
 * @method addHourGlassByParams(array $params)
 * @method editHourGlassByParams(array $params)
 * @method deleteHourGlassByParams(array $params)
 * @method addCardByParams(array $params)
 * @method closeCardByParams(array $params)
 * @method deleteCardByParams(array $params)
 * @method getStaffCardListByParams(array $params)
 * @method getImpulseListByParams(array $params)
 * @method addImpulseByParams(array $params)
 * @method addImpulseSettingItemByParams(array $params)
 * @method delImpulseSettingItemByParams(array $params)
 * @method getImpulseSettingItemListByParams(array $params)
 * @method getImpulseInfoByParams(array $params)
 * @method deleteImpulseByParams(array $params)
 * @method disableImpulseByParams(array $params)
 * @method getGreenChannelInfoByParams(array $params)
 * @method saveGreenChannelInfoByParams(array $params)
 * @method getSuggestWorkloadByParams(array $params)
 * @method saveSuggestWorkloadByParams(array $params)
 */
class Config {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取沙漏列表
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHourGlassList (int $page, int $page_size) {
        return self::getClass()->getHourGlassList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取沙漏详情
     *
     * @param  int $configId 配置id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHourGlassInfo (int $configId) {
        return self::getClass()->getHourGlassInfo([
            "configId" => $configId,
        ]);
    }

    /**
     * 开启全局沙漏状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableHourGlassGlobalState () {
        return self::getClass()->enableHourGlassGlobalState();
    }

    /**
     * 关闭全局沙漏状态
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableHourGlassGlobalState () {
        return self::getClass()->disableHourGlassGlobalState();
    }

    /**
     * 添加沙漏
     *
     * @param  array $retouch_standards 修图标准 [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @param  array $staff_ranges 伙伴范围 [ require true ]
     * @param  int $base_time 基础时间 [ require true ]
     * @param  int $superimposed_time 叠加时间 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addHourGlass (array $retouch_standards, array $product_ids = [], array $staff_ranges, int $base_time, int $superimposed_time) {
        return self::getClass()->addHourGlass([
            "retouch_standards" => $retouch_standards,
            "product_ids" => $product_ids,
            "staff_ranges" => $staff_ranges,
            "base_time" => $base_time,
            "superimposed_time" => $superimposed_time,
        ]);
    }

    /**
     * 编辑沙漏
     *
     * @param  int $config_id 配置id [ require true ]
     * @param  array $retouch_standards 修图标准 [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @param  array $staff_ranges 伙伴范围 [ require true ]
     * @param  int $base_time 基础时间 [ require true ]
     * @param  int $superimposed_time 叠加时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editHourGlass (int $config_id, array $retouch_standards, array $product_ids, array $staff_ranges, int $base_time, int $superimposed_time) {
        return self::getClass()->editHourGlass([
            "config_id" => $config_id,
            "retouch_standards" => $retouch_standards,
            "product_ids" => $product_ids,
            "staff_ranges" => $staff_ranges,
            "base_time" => $base_time,
            "superimposed_time" => $superimposed_time,
        ]);
    }

    /**
     * 删除沙漏
     *
     * @param  int $config_id 配置id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteHourGlass (int $config_id) {
        return self::getClass()->deleteHourGlass([
            "config_id" => $config_id,
        ]);
    }

    /**
     * 添加伙伴卡片配置
     *
     * @param  string $type 卡片类型 [ require true ]
     * @param  float $multiple 倍数 [Original type double] [ require true ]
     * @param  array $staff_ids 伙伴id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addCard (string $type, float $multiple, array $staff_ids) {
        return self::getClass()->addCard([
            "type" => $type,
            "multiple" => $multiple,
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 关闭卡片配置
     *
     * @param  int $staff_card_id 伙伴的某张卡片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeCard (int $staff_card_id) {
        return self::getClass()->closeCard([
            "staff_card_id" => $staff_card_id,
        ]);
    }

    /**
     * 删除卡片配置
     *
     * @param  int $staff_card_id 伙伴的某张卡片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteCard (int $staff_card_id) {
        return self::getClass()->deleteCard([
            "staff_card_id" => $staff_card_id,
        ]);
    }

    /**
     * 获取已配置卡片列表
     *
     * @support  string $type 状态 [ require true ]
     * @support  string $state 状态 
     * @support  array $staff_ids 伙伴id 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffCardList (int $page, int $page_size) {
        return self::getClass()->getStaffCardList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 获取已配置冲量奖励列表
     *
     * @support  string $state 状态 
     * @support  int $staff_id 伙伴ID 
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseList (int $page, int $page_size) {
        return self::getClass()->getImpulseList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 新增冲量奖励
     *
     * @support  string $title 标题 [ require true ]
     * @support  array $staff_id 伙伴id数组 [ require true ]
     * @support  array $setting_item_id 配置id [ require true ]
     * @support  string $start_at 生效日期 [ require true ]
     * @support  string $end_at 结束日期 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addImpulse () {
        return self::getClass()->addImpulse();
    }

    /**
     * 新增冲量奖励配置
     *
     * @support  int $reachExp 需要的海草 [ require true ]
     * @support  int $reward 配置id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addImpulseSettingItem () {
        return self::getClass()->addImpulseSettingItem();
    }

    /**
     * 删除冲量奖励配置
     *
     * @param  int $item_id 冲量奖励配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delImpulseSettingItem (int $item_id) {
        return self::getClass()->delImpulseSettingItem([
            "item_id" => $item_id,
        ]);
    }

    /**
     * 获取冲量奖励配置项列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseSettingItemList () {
        return self::getClass()->getImpulseSettingItemList();
    }

    /**
     * 获取冲量奖励详情
     *
     * @param  int $impulse_id 配置id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getImpulseInfo (int $impulse_id) {
        return self::getClass()->getImpulseInfo([
            "impulse_id" => $impulse_id,
        ]);
    }

    /**
     * 删除冲量奖励
     *
     * @param  int $impulse_id 配置id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function deleteImpulse (int $impulse_id) {
        return self::getClass()->deleteImpulse([
            "impulse_id" => $impulse_id,
        ]);
    }

    /**
     * 关闭冲量奖励
     *
     * @param  int $impulse_id 配置id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableImpulse (int $impulse_id) {
        return self::getClass()->disableImpulse([
            "impulse_id" => $impulse_id,
        ]);
    }

    /**
     * 获取绿色通道人员
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGreenChannelInfo () {
        return self::getClass()->getGreenChannelInfo();
    }

    /**
     * 更新绿色通道人员
     *
     * @param  array $staff_ids 员工id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveGreenChannelInfo (array $staff_ids) {
        return self::getClass()->saveGreenChannelInfo([
            "staff_ids" => $staff_ids,
        ]);
    }

    /**
     * 获取建议工作量
     *
     * @param  int $retouchClassId 修图类别id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuggestWorkload (int $retouchClassId) {
        return self::getClass()->getSuggestWorkload([
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * 保存建议工作量
     *
     * @param  int $retouchClassId 修图类别id [ require true ]
     * @support  array $suggestWorkload 建议工作量 
     * @throws  \Exception
     * @return  array
     */
    public static function saveSuggestWorkload (int $retouchClassId) {
        return self::getClass()->saveSuggestWorkload([
            "retouchClassId" => $retouchClassId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Config');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Config');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}