<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSignatureByParams(array $params)
 * @method getPhotoInfoByParams(array $params)
 */
class PhotoManager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云上传凭证
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSignature () {
        return self::getClass()->getSignature();
    }

    /**
     * 按照片uuid获取照片列表
     *
     * @support  string $uuid uuid [ require true ]
     * @support  string $version 版本名称 
     * @support  string $position 位置 
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoInfo () {
        return self::getClass()->getPhotoInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'PhotoManager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}