<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array $params)
 * @method batchGetOrderInfoByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method closeOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @support  string $storeName 门店名称 
     * @support  string $photographer 摄影师 
     * @support  string $dresserNote 化妆师备注 
     * @support  string $orderNote 订单备注 
     * @throws  \Exception
     * @return  int
     */
    public static function createOrder (string $externalNum) {
        return self::getClass()->createOrder([
            "externalNum" => $externalNum,
        ]);
    }

    /**
     * 批量获取订单信息
     *
     * @param  array $externalNums 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchGetOrderInfo (array $externalNums) {
        return self::getClass()->batchGetOrderInfo([
            "externalNums" => $externalNums,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (string $externalNum) {
        return self::getClass()->getOrderInfo([
            "externalNum" => $externalNum,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  string $externalNum 外部订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (string $externalNum) {
        return self::getClass()->closeOrder([
            "externalNum" => $externalNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}