<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpunSignByParams(array $params)
 * @method submitFinalFilmByParams(array $params)
 * @method batchGetPhotoInfoByIdByParams(array $params)
 * @method firstPhotoInfoByIdByParams(array $params)
 * @method getHostByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUpunSign () {
        return self::getClass()->getUpunSign();
    }

    /**
     * 提交最终成片[看片完成]
     *
     * @param  array $versionData 成片信息 [ require true ]
     * @param  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function submitFinalFilm (array $versionData, string $streamNum) {
        return self::getClass()->submitFinalFilm([
            "versionData" => $versionData,
            "streamNum" => $streamNum,
        ]);
    }

    /**
     * 根据照片id批量获取照片信息
     *
     * @param  array $ids 照片id [ require true ]
     * @param  string $position 版本位置 [ require true ]
     * @param  string $version 版本名称 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function batchGetPhotoInfoById (array $ids, string $position, string $version = NULL) {
        return self::getClass()->batchGetPhotoInfoById([
            "ids" => $ids,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 根据id获取照片信息
     *
     * @param  int $id 照片id [ require true ]
     * @param  string $position 获取当前版本的第一个或者最后一个 [ require true ]
     * @param  string $version 照片版本 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function firstPhotoInfoById (int $id, string $position, string $version = NULL) {
        return self::getClass()->firstPhotoInfoById([
            "id" => $id,
            "position" => $position,
            "version" => $version,
        ]);
    }

    /**
     * 返回host
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}