<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStaffListByPageByParams(array $params)
 * @method searchStaffInfoByParams(array $params)
 * @method getStaffPermissionByParams(array $params)
 * @method addStaffByParams(array $params)
 * @method editStaffByParams(array $params)
 * @method enableStaffByParams(array $params)
 * @method disableStaffByParams(array $params)
 * @method addRetoucherClassByParams(array $params)
 * @method editRetoucherClassByParams(array $params)
 * @method delRetoucherClassByParams(array $params)
 * @method getRetoucherClassInfoByParams(array $params)
 * @method getRetoucherClassListByParams(array $params)
 * @method addRoleByParams(array $params)
 * @method editRoleByParams(array $params)
 * @method delRoleByParams(array $params)
 * @method getRoleInfoByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method getPermissionListByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取账号列表
     *
     * @param  string $staffName 伙伴姓名/花名 [ require true ]
     * @param  int $roleId 角色id [Original type uint] [ require true ]
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页大小 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffListByPage (string $staffName = '', int $roleId = 0, int $page = 1, int $pageSize) {
        return self::getClass()->getStaffListByPage([
            "staffName" => $staffName,
            "roleId" => $roleId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 查询伙伴信息
     *
     * @param  int $staff_num 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchStaffInfo (int $staff_num) {
        return self::getClass()->searchStaffInfo([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 查询伙伴权限信息
     *
     * @param  int $staff_num 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermission (int $staff_num) {
        return self::getClass()->getStaffPermission([
            "staff_num" => $staff_num,
        ]);
    }

    /**
     * 添加伙伴
     *
     * @support  array $product_ids 可接产品ids [ require true ]
     * @support  int $retoucher_class 修图师类别 [Original type uint] [ require true ]
     * @support  array $role_ids 角色组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  array $permission_ids 权限ids [ require true ]
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStaff () {
        return self::getClass()->addStaff();
    }

    /**
     * 编辑伙伴
     *
     * @support  int $staff_num 工号 [Original type uint] [ require true ]
     * @support  array $product_ids 可接产品ids [ require true ]
     * @support  int $retoucher_class 修图师类别 [Original type uint] [ require true ]
     * @support  array $role_ids 角色组 [Original type array&lt;uint&gt;] [ require true ]
     * @support  array $permission_ids 权限ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editStaff () {
        return self::getClass()->editStaff();
    }

    /**
     * 启用伙伴
     *
     * @param  int $staff_id staff_id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableStaff (int $staff_id) {
        return self::getClass()->enableStaff([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 禁用伙伴
     *
     * @param  int $staff_id staff_id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableStaff (int $staff_id) {
        return self::getClass()->disableStaff([
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 添加按照产品划分的 修片师类别
     *
     * @param  string $name 名称 [ require true ]
     * @param  array $product_ids 可接产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRetoucherClass (string $name, array $product_ids) {
        return self::getClass()->addRetoucherClass([
            "name" => $name,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 编辑按照产品划分的 修片师类别
     *
     * @param  int $retoucher_class_id id [Original type uint] [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  array $product_ids 可接产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetoucherClass (string $name, array $product_ids, int $retoucher_class_id) {
        return self::getClass()->editRetoucherClass([
            "name" => $name,
            "product_ids" => $product_ids,
            "retoucher_class_id" => $retoucher_class_id,
        ]);
    }

    /**
     * 删除按照产品划分的 修片师类别
     *
     * @param  int $retoucherClassId id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRetoucherClass (int $retoucherClassId) {
        return self::getClass()->delRetoucherClass([
            "retoucherClassId" => $retoucherClassId,
        ]);
    }

    /**
     * 获取按照产品划分的 修片师类别
     *
     * @param  int $retoucherClassId 修片师类别id [Original type uint] [ require true ]
     * @param  bool $additionInfo 附加信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetoucherClassInfo (int $retoucherClassId, bool $additionInfo = false) {
        return self::getClass()->getRetoucherClassInfo([
            "retoucherClassId" => $retoucherClassId,
            "additionInfo" => $additionInfo,
        ]);
    }

    /**
     * 获取按照产品划分的 修片师类别 列表
     *
     * @param  string $retouch_class_name 修图类别名称 [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherClassList (string $retouch_class_name, int $page = 1, int $page_size = 20) {
        return self::getClass()->getRetoucherClassList([
            "retouch_class_name" => $retouch_class_name,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 添加角色
     *
     * @support  string $title 角色组名称 [ require true ]
     * @support  array $permission_ids 权限数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addRole () {
        return self::getClass()->addRole();
    }

    /**
     * 设置角色权限
     *
     * @support  int $role_id 角色组id [ require true ]
     * @support  array $permission_ids 权限数组 [ require true ]
     * @support  string $title 标题 
     * @support  string $desc 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRole () {
        return self::getClass()->editRole();
    }

    /**
     * 删除角色
     *
     * @param  int $role_id 角色组id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delRole (int $role_id) {
        return self::getClass()->delRole([
            "role_id" => $role_id,
        ]);
    }

    /**
     * 获取角色信息
     *
     * @param  int $role_id 角色组id [Original type uint] [ require true ]
     * @param  bool $addition_info 额外信息，是否有作用的伙伴 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleInfo (int $role_id, bool $addition_info = false) {
        return self::getClass()->getRoleInfo([
            "role_id" => $role_id,
            "addition_info" => $addition_info,
        ]);
    }

    /**
     * 获取角色列表
     *
     * @support  string $title 搜索角色名字 
     * @support  int $page 分页 
     * @support  int $page_size 每页大小 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRoleList () {
        return self::getClass()->getRoleList();
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissionList () {
        return self::getClass()->getPermissionList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}