<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTodayQuotaByParams(array $params)
 * @method getGroupStaffTodayQuotaListByParams(array $params)
 * @method changeGroupStaffWorkLoadByParams(array $params)
 * @method getGroupStaffQuotaInfoByParams(array $params)
 * @method getStaffRetouchListByParams(array $params)
 */
class RetouchLeader {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取今日指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getTodayQuota () {
        return self::getClass()->getTodayQuota();
    }

    /**
     * 获取组员今日指标列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffTodayQuotaList () {
        return self::getClass()->getGroupStaffTodayQuotaList();
    }

    /**
     * 修改组员工作量【仅限今日】
     *
     * @support  int $staff_id 伙伴id [Original type uint] [ require true ]
     * @support  int $expect 预计工作量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeGroupStaffWorkLoad () {
        return self::getClass()->changeGroupStaffWorkLoad();
    }

    /**
     * 获取组员修图报告【可查询全部】
     *
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupStaffQuotaInfo () {
        return self::getClass()->getGroupStaffQuotaInfo();
    }

    /**
     * 获取组员修图记录
     *
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @support  string $start_at 开始时间 [ require true ]
     * @support  string $end_at 结束时间 [ require true ]
     * @support  string $plant_pull 审核种拔草 
     * @support  string $spot_check_plant_pull 抽查种拔草 
     * @support  int $page page [Original type uint] 
     * @support  int $page_size page_size [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffRetouchList () {
        return self::getClass()->getStaffRetouchList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'RetouchLeader');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}