<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStreamInfoByParams(array $params)
 * @method getAllRetouchClassByParams(array $params)
 * @method getAllProductByParams(array $params)
 * @method getAllRoleByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 * @method getProductInfoByParams(array $params)
 * @method getAuthorityByParams(array $params)
 * @method getStaffListByParams(array $params)
 * @method getSelfStaffsByParams(array $params)
 * @method getCloudRetoucherByParams(array $params)
 * @method getOuterRetoucherByParams(array $params)
 * @method getReviewerByParams(array $params)
 * @method getRetoucherGroupByParams(array $params)
 * @method getPhotographerOrgByParams(array $params)
 * @method getRetoucherOrgByParams(array $params)
 * @method getRetoucherOrgWithProductByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取流水信息
     *
     * @support  int $stream_id 流水id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo () {
        return self::getClass()->getStreamInfo();
    }

    /**
     * 获取全部修图类型
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRetouchClass () {
        return self::getClass()->getAllRetouchClass();
    }

    /**
     * 获取全部产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProduct () {
        return self::getClass()->getAllProduct();
    }

    /**
     * 获取全部角色组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRole () {
        return self::getClass()->getAllRole();
    }

    /**
     * 获取订单信息
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo () {
        return self::getClass()->getOrderInfo();
    }

    /**
     * 获取产品信息
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAuthority () {
        return self::getClass()->getAuthority();
    }

    /**
     * 获取伙伴列表
     *
     * @param  bool $need_group 是否需要组信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffList (bool $need_group) {
        return self::getClass()->getStaffList([
            "need_group" => $need_group,
        ]);
    }

    /**
     * 获取自己所有组员
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfStaffs () {
        return self::getClass()->getSelfStaffs();
    }

    /**
     * 获取云端所有修图师
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCloudRetoucher () {
        return self::getClass()->getCloudRetoucher();
    }

    /**
     * 获取外包所有修图师
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOuterRetoucher () {
        return self::getClass()->getOuterRetoucher();
    }

    /**
     * 获取所有审核人
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewer () {
        return self::getClass()->getReviewer();
    }

    /**
     * 获取所有修图组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGroup () {
        return self::getClass()->getRetoucherGroup();
    }

    /**
     * 获取摄影机构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotographerOrg () {
        return self::getClass()->getPhotographerOrg();
    }

    /**
     * 获取修片机构
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherOrg () {
        return self::getClass()->getRetoucherOrg();
    }

    /**
     * 获取修片机构及下面的产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherOrgWithProduct () {
        return self::getClass()->getRetoucherOrgWithProduct();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}