<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getGroupReviewQuotaByParams(array $params)
 * @method getReviewListByParams(array $params)
 */
class ReviewLeader {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取小组审核指标[整小组或者个人]
     *
     * @support  string $range 自己审核还是组员审核 [ require true ]
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @support  int $staffId 伙伴id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getGroupReviewQuota () {
        return self::getClass()->getGroupReviewQuota();
    }

    /**
     * 获取审核记录列表
     *
     * @support  string $range 自己审核还是组员审核 [ require true ]
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  int $staff_id 伙伴id [Original type uint] 
     * @support  string $plant_pull 审核种拔草 
     * @support  string $rectify 纠偏意见 
     * @support  string $spot_check_plant_pull 抽查种拔草 
     * @support  int $page_size page_size [Original type uint] 
     * @support  int $page page [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getReviewList () {
        return self::getClass()->getReviewList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'ReviewLeader');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'ReviewLeader');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}