<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method disableProductByParams(array $params)
 * @method enableProductByParams(array $params)
 * @method getProductListByIdsByParams(array $params)
 * @method getProductInfoByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $retouch_require 修片要求 [ require true ]
     * @support  array $simple_image_url 样片地址 [ require true ]
     * @support  int $photographer_org_id 机构id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * 禁用产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableProduct (int $product_id) {
        return self::getClass()->disableProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 启用产品
     *
     * @param  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableProduct (int $product_id) {
        return self::getClass()->enableProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取待审核产品列表
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @param  int $photographer_org_id 摄影机构id [ require true ]
     * @param  string $token api_token [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $page_size 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductListByIds (array $product_ids, int $page, int $page_size, int $photographer_org_id, string $token = NULL) {
        return self::getClass()->getProductListByIds([
            "product_ids" => $product_ids,
            "page" => $page,
            "page_size" => $page_size,
            "photographer_org_id" => $photographer_org_id,
            "token" => $token,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductInfo (int $productId) {
        return self::getClass()->getProductInfo([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}