<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method streamMatchRetoucherByParams(array $params)
 * @method autoEndImpulseByParams(array $params)
 * @method expireImpulseByParams(array $params)
 * @method autoEndStaffCardByParams(array $params)
 * @method expireStaffCardByParams(array $params)
 * @method YearAwardByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 匹配一对
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function streamMatchRetoucher () {
        return self::getClass()->streamMatchRetoucher();
    }

    /**
     * 自动结束冲量buff
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndImpulse () {
        return self::getClass()->autoEndImpulse();
    }

    /**
     * 过期冲量奖
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireImpulse () {
        return self::getClass()->expireImpulse();
    }

    /**
     * 结束卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoEndStaffCard () {
        return self::getClass()->autoEndStaffCard();
    }

    /**
     * 过期卡片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function expireStaffCard () {
        return self::getClass()->expireStaffCard();
    }

    /**
     * 年终奖(小蜜蜂)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function YearAward () {
        return self::getClass()->YearAward();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}