<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method joinQueueByParams(array $params)
 * @method exitQueueByParams(array $params)
 * @method haveReworkStreamByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 * @method getRetouchStreamsByParams(array $params)
 * @method getStreamQueueInfoByParams(array $params)
 * @method submitStreamByParams(array $params)
 * @method getSelfQuotaByParams(array $params)
 * @method hangStreamByParams(array $params)
 * @method getRankInfoByParams(array $params)
 * @method getPropsByParams(array $params)
 * @method usePropByParams(array $params)
 * @method getRetouchQuotaByParams(array $params)
 * @method getLittleBeeInfoByParams(array $params)
 * @method getRetouchQuotaListByParams(array $params)
 * @method getSelfBuffInfoByParams(array $params)
 */
class Retoucher {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 进入队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinQueue () {
        return self::getClass()->joinQueue();
    }

    /**
     * 退出队列
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function exitQueue () {
        return self::getClass()->exitQueue();
    }

    /**
     * 有流水退单[有就返回流水单号]
     *
     * @throws  \Exception
     * @return  array
     */
    public static function haveReworkStream () {
        return self::getClass()->haveReworkStream();
    }

    /**
     * 获取流水信息
     *
     * @param  int $streamId 流水id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (int $streamId) {
        return self::getClass()->getStreamInfo([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取流水列表[待修，挂起]
     *
     * @param  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchStreams (string $state) {
        return self::getClass()->getRetouchStreams([
            "state" => $state,
        ]);
    }

    /**
     * 获取待修片队列信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamQueueInfo () {
        return self::getClass()->getStreamQueueInfo();
    }

    /**
     * 提交已修流水
     *
     * @support  int $streamId 流水号 [Original type uint] [ require true ]
     * @support  array $photoData 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitStream () {
        return self::getClass()->submitStream();
    }

    /**
     * 获取个人今日指标
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfQuota () {
        return self::getClass()->getSelfQuota();
    }

    /**
     * 挂起流水[仅能挂起缦图订单]
     *
     * @param  int $streamId 流水id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hangStream (int $streamId) {
        return self::getClass()->hangStream([
            "streamId" => $streamId,
        ]);
    }

    /**
     * 获取个人修图等级信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRankInfo () {
        return self::getClass()->getRankInfo();
    }

    /**
     * 获取道具
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getProps () {
        return self::getClass()->getProps();
    }

    /**
     * 使用道具
     *
     * @param  int $id 道具id[目前只有卡片] [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useProp (int $id) {
        return self::getClass()->useProp([
            "id" => $id,
        ]);
    }

    /**
     * todo 这里指标加一下
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchQuota () {
        return self::getClass()->getRetouchQuota();
    }

    /**
     * 获取小蜜蜂奖励信息
     *
     * @param  int $year 年份 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLittleBeeInfo (int $year) {
        return self::getClass()->getLittleBeeInfo([
            "year" => $year,
        ]);
    }

    /**
     * 获取历史修图报告列表
     *
     * @support  int $page page [Original type uint] [ require true ]
     * @support  int $pageSize pageSize [Original type uint] [ require true ]
     * @support  string $grass 种拔草 
     * @support  string $startAt 开始时间 
     * @support  string $endAt 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getRetouchQuotaList () {
        return self::getClass()->getRetouchQuotaList();
    }

    /**
     * 获取个人buff信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfBuffInfo () {
        return self::getClass()->getSelfBuffInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Retoucher');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Retoucher');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}