<?php
namespace Mainto\Bridge\Invokes\ProjectCloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method takeItemByParams(array $params)
 * @method getHaveSpotCheckResultByParams(array $params)
 * @method getSpotCheckResultByParams(array $params)
 * @method getSearchHistoryByParams(array $params)
 * @method commitHistoryByParams(array $params)
 */
class CheckPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云学院抽片
     *
     * @support  int $takeNum 抽取数量 [ require true ]
     * @support  string $passStartAt 审核通过开始时间 [ require true ]
     * @support  string $passEndAt 审核通过结束时间 [ require true ]
     * @support  string $retouchStandard 修片标准 
     * @throws  \Exception
     * @return  string
     */
    public static function takeItem () {
        return self::getClass()->takeItem();
    }

    /**
     * 获取是否有未评分的抽片
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHaveSpotCheckResult () {
        return self::getClass()->getHaveSpotCheckResult();
    }

    /**
     * 获取抽片结果
     *
     * @support  string $uuid 抽查配置UUID [ require true ]
     * @support  int $skip 跳过数量 [Original type uint] 
     * @support  int $limit 获取数量 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSpotCheckResult () {
        return self::getClass()->getSpotCheckResult();
    }

    /**
     * 获取抽片历史记录
     *
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $grassType 种草类型 
     * @support  string $correctionType 纠偏 
     * @support  int $retoucherId 修图师id 
     * @support  int $reviewerId 审核人员 
     * @support  int $page 页数 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getSearchHistory () {
        return self::getClass()->getSearchHistory();
    }

    /**
     * 提交
     *
     * @param  string $uuid uuid [ require true ]
     * @param  string $photoId 照片id [ require true ]
     * @support  string $auditCorrection 纠偏类型 [ require true ]
     * @support  string $auditGlass 纠偏种草 [ require true ]
     * @support  string $auditNote 纠偏备注 
     * @support  string $filmEvaluation 成片种拔草 [ require true ]
     * @support  string $filmTag 成片标签 
     * @support  string $evaluationNote 成片备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function commitHistory (string $uuid, string $photoId) {
        return self::getClass()->commitHistory([
            "uuid" => $uuid,
            "photoId" => $photoId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'CheckPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'CheckPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}