<?php
namespace Mainto\Bridge\Invokes\ProjectCloud\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUpunSignByParams(array $params)
 * @method submitFinalFilmByParams(array $params)
 * @method batchGetPhotoInfoByUuidByParams(array $params)
 * @method getPhotoInfoByUuidByParams(array $params)
 * @method batchGetPhotoInfoByIdByParams(array $params)
 * @method getPhotoInfoByIdByParams(array $params)
 */
class Photo {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取又拍云签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUpunSign () {
        return self::getClass()->getUpunSign();
    }

    /**
     * 提交最终成片
     *
     * @param  array $versionData 成片信息 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function submitFinalFilm (array $versionData) {
        return self::getClass()->submitFinalFilm([
            "versionData" => $versionData,
        ]);
    }

    /**
     * 根据uuid批量获取照片信息
     *
     * @param  array $uuids 照片uuid [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function batchGetPhotoInfoByUuid (array $uuids) {
        return self::getClass()->batchGetPhotoInfoByUuid([
            "uuids" => $uuids,
        ]);
    }

    /**
     * 根据uuid获取照片信息
     *
     * @param  string $uuid 照片uuid [ require true ]
     * @support  string $position 获取当前版本的第一个或者最后一个 
     * @support  string $version 照片版本 
     * @throws  \Exception
     * @return  string
     */
    public static function getPhotoInfoByUuid (string $uuid) {
        return self::getClass()->getPhotoInfoByUuid([
            "uuid" => $uuid,
        ]);
    }

    /**
     * 根据id批量获取照片信息
     *
     * @param  array $ids 成片信息 [ require true ]
     * @support  string $position 获取当前版本的第一个或者最后一个 
     * @support  string $version 照片版本 
     * @throws  \Exception
     * @return  string
     */
    public static function batchGetPhotoInfoById (array $ids) {
        return self::getClass()->batchGetPhotoInfoById([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据id获取照片信息
     *
     * @param  int $id 照片id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoInfoById (int $id) {
        return self::getClass()->getPhotoInfoById([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloud', 'Api\Photo');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}