<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Announcement;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method recordListByParams(array $params)
 * @method deleteByParams(array $params)
 * @method hookInitMessageByParams(array $params)
 * @method hookSendMessageByParams(array $params)
 * @method hookDeleteMessageByParams(array $params)
 */
class AnnouncementManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增公告
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $type 类型 [ require true ]
     * @support  string $brief 简介 [ require true ]
     * @support  string $content 内容 [ require true ]
     * @support  string $receiverType 通知接收人类型 [ require true ]
     * @support  bool $immediate 是否立即通知 [ require false ]
     * @support  string $sendAt 通知时间 [ require false ]
     * @support  array $files 文件 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 公告列表
     *
     * @support  mixed $conds 搜索条件 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 公告详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 公告发送记录列表
     *
     * @param  int $id id [ require true ]
     * @param  int $page id [ require false ]
     * @param  int $pageSize id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recordList (int $id, int $page = 1, int $pageSize = 10) {
        return self::getClass()->recordList([
            "id" => $id,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除公告
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 触发初始化公告日志
     *
     * @param  int $id id [ require true ]
     * @param  array $receiverIds id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookInitMessage (int $id, array $receiverIds = []) {
        return self::getClass()->hookInitMessage([
            "id" => $id,
            "receiverIds" => $receiverIds,
        ]);
    }

    /**
     * 触发发送公告WS
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSendMessage (int $id) {
        return self::getClass()->hookSendMessage([
            "id" => $id,
        ]);
    }

    /**
     * 触发异步检查删除公告记录
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookDeleteMessage (int $id) {
        return self::getClass()->hookDeleteMessage([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Announcement\AnnouncementManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Announcement\AnnouncementManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}