<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Achievement;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRetoucherGoalsByParams(array $params)
 * @method editRetoucherGoalByParams(array $params)
 * @method getTotalRetoucherGoalByParams(array $params)
 * @method getRetoucherGoalFinishRateByParams(array $params)
 * @method getRetoucherGoalStateByDateByParams(array $params)
 */
class RetoucherGoal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 组员修图目标-列表
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGoals (string $date) {
        return self::getClass()->getRetoucherGoals([
            "date" => $date,
        ]);
    }

    /**
     * 组员修图目标-修改组内目标值
     *
     * @param  array $staffGoals 小伙伴目标值 [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function editRetoucherGoal (array $staffGoals, string $date) {
        return self::getClass()->editRetoucherGoal([
            "staffGoals" => $staffGoals,
            "date" => $date,
        ]);
    }

    /**
     * 组员修图目标-今日目标统计
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTotalRetoucherGoal (string $date) {
        return self::getClass()->getTotalRetoucherGoal([
            "date" => $date,
        ]);
    }

    /**
     * 获取个人完成率列表
     *
     * @param  string $startAt 开始时间 [ require true ]
     * @param  string $endAt 结束时间 [ require true ]
     * @param  int $staffId 员工id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGoalFinishRate (string $startAt, string $endAt, int $staffId = null) {
        return self::getClass()->getRetoucherGoalFinishRate([
            "startAt" => $startAt,
            "endAt" => $endAt,
            "staffId" => $staffId,
        ]);
    }

    /**
     * getRetoucherGoalStateByDate
     *
     * @param  string $date 日期 [ require true ]
     * @param  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGoalStateByDate (string $date, int $staffId) {
        return self::getClass()->getRetoucherGoalStateByDate([
            "date" => $date,
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Achievement\RetoucherGoal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Achievement\RetoucherGoal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}