<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Attendance;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method groupApplyByParams(array $params)
 * @method staffApplyByParams(array $params)
 * @method getCurrentLeaveApplyByParams(array $params)
 * @method getWaitExamineApplyListByParams(array $params)
 * @method examineByParams(array $params)
 * @method batchExamineByParams(array|\Mainto\Bridge\Structs\ProjectCloudOa\Cmd\LeaveBatchExamineCmd $params)
 * @method getGroupLeaveRecordListByParams(array $params)
 */
class Leave {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 小组离岗申请
     *
     * @param  string $date 日期 [ require true ]
     * @param  array $leaveGroup 请假数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupApply (string $date, array $leaveGroup) {
        return self::getClass()->groupApply([
            "date" => $date,
            "leaveGroup" => $leaveGroup,
        ]);
    }

    /**
     * 组员个别离岗申请
     *
     * @param  string $date 日期 [ require true ]
     * @param  array $leaveStaffs staff数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function staffApply (string $date, array $leaveStaffs) {
        return self::getClass()->staffApply([
            "date" => $date,
            "leaveStaffs" => $leaveStaffs,
        ]);
    }

    /**
     * 获取小组待审批记录
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentLeaveApply (string $date) {
        return self::getClass()->getCurrentLeaveApply([
            "date" => $date,
        ]);
    }

    /**
     * 运营获取所有小组待审批记录列表
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWaitExamineApplyList (string $date) {
        return self::getClass()->getWaitExamineApplyList([
            "date" => $date,
        ]);
    }

    /**
     * 运营审批
     *
     * @param  string $_id id [ require true ]
     * @param  string $result 审批结果 [ require true ]
     * @support  string $reason 拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function examine (string $_id, string $result) {
        return self::getClass()->examine([
            "_id" => $_id,
            "result" => $result,
        ]);
    }

    /**
     * 运营批量审批
     *
     * @var  \Mainto\Bridge\Structs\ProjectCloudOa\Cmd\LeaveBatchExamineCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function batchExamine (\Mainto\Bridge\Structs\ProjectCloudOa\Cmd\LeaveBatchExamineCmd $cmd) {
        return self::getClass()->batchExamine($cmd);
    }


    /**
     * 获取小组某日请假情况列表
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupLeaveRecordList (string $date) {
        return self::getClass()->getGroupLeaveRecordList([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Attendance\Leave');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Attendance\Leave');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}