<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCloudRetouchQueueNightLengthByParams(array $params)
 * @method hookCloudWaitRetouchPhotoCountByParams(array $params)
 * @method hookCloudPassConfigNotifyByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听晚上十点云端蓝标单量,如果为0则云端全体成员完成目标
     *
     * @support  int $blue 蓝标单长度 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloudRetouchQueueNightLength () {
        return self::getClass()->hookCloudRetouchQueueNightLength();
    }

    /**
     * 监听早上八点云端蓝标单量，如果有单则，照片算入今天的上传照片数
     *
     * @support  int $leave_photo_num 剩余照片张数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloudWaitRetouchPhotoCount () {
        return self::getClass()->hookCloudWaitRetouchPhotoCount();
    }

    /**
     * 监听云端发送公告
     *
     * @param  int $creatorId 创建人 [ require true ]
     * @param  mixed $data 公告信息组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hookCloudPassConfigNotify ($data, int $creatorId = 0) {
        return self::getClass()->hookCloudPassConfigNotify([
            "data" => $data,
            "creatorId" => $creatorId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}