<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Attendance;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method groupApplyByParams(array $params)
 * @method staffApplyByParams(array $params)
 * @method getCurrentLeaveApplyByParams(array $params)
 */
class Leave {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 小组离岗申请
     *
     * @param  int $groupId 组id [ require true ]
     * @param  string $date 日期 [ require true ]
     * @param  array $leaveGroup 请假数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupApply (string $date, int $groupId, array $leaveGroup) {
        return self::getClass()->groupApply([
            "date" => $date,
            "groupId" => $groupId,
            "leaveGroup" => $leaveGroup,
        ]);
    }

    /**
     * 组员个别离岗申请
     *
     * @param  int $groupId 组id [ require true ]
     * @param  string $date 日期 [ require true ]
     * @param  array $leaveStaffs staff数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function staffApply (string $date, int $groupId, array $leaveStaffs) {
        return self::getClass()->staffApply([
            "date" => $date,
            "groupId" => $groupId,
            "leaveStaffs" => $leaveStaffs,
        ]);
    }

    /**
     * getCurrentLeaveApply
     *
     * @param  int $groupId 组id [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentLeaveApply (string $date, int $groupId) {
        return self::getClass()->getCurrentLeaveApply([
            "date" => $date,
            "groupId" => $groupId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Attendance\Leave');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Attendance\Leave');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}