<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Achievement;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setOverallGoalTodayByParams(array $params)
 * @method getOverallStatisticsByParams(array $params)
 */
class OverallGoal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云端总体每日目标张数设定
     *
     * @param  int $num 每日总体目标张数 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setOverallGoalToday (int $num) {
        return self::getClass()->setOverallGoalToday([
            "num" => $num,
        ]);
    }

    /**
     * 云端总体张数相关统计
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOverallStatistics (string $date) {
        return self::getClass()->getOverallStatistics([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Achievement\OverallGoal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Achievement\OverallGoal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}