<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testGetWsUsersByParams(array $params)
 * @method initPhotoNumGoalBaseDataByParams(array $params)
 * @method initStaffScheduleByParams(array $params)
 * @method mockStaffScheduleByParams(array $params)
 * @method mockEditStaffScheduleByParams(array $params)
 * @method reCalculateByParams(array $params)
 * @method initDayAlarmLogByParams(array $params)
 * @method sendDayPhotoThroughputNoticeByParams(array $params)
 * @method photoAlarmCheckByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取WS列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function testGetWsUsers () {
        return self::getClass()->testGetWsUsers();
    }

    /**
     * 初始化员工绩效目标数据 temp接口
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initPhotoNumGoalBaseData (string $date) {
        return self::getClass()->initPhotoNumGoalBaseData([
            "date" => $date,
        ]);
    }

    /**
     * 考勤数据--正式
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initStaffSchedule (string $date) {
        return self::getClass()->initStaffSchedule([
            "date" => $date,
        ]);
    }

    /**
     * mock考勤数据---测试用
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mockStaffSchedule (string $date) {
        return self::getClass()->mockStaffSchedule([
            "date" => $date,
        ]);
    }

    /**
     * mock考勤数据---测试用
     *
     * @support  string $date 日期 [ require true ]
     * @support  array $staffIds idArray [ require true ]
     * @support  bool $onDuty 是否上班 require false
     * @support  bool $workOutside 是否外勤 require false
     * @support  bool $workOverTime 是否加班 require false
     * @support  float $leaveDuration 请假时长 require false
     * @support  int $baseGoalLevel 基础目标张数,等级 1，2是新人,中间按表排列, 8是大师修修兽 9是缦图,影响修图标准与是否为新人 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function mockEditStaffSchedule () {
        return self::getClass()->mockEditStaffSchedule();
    }

    /**
     * 核算接口
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reCalculate (string $date) {
        return self::getClass()->reCalculate([
            "date" => $date,
        ]);
    }

    /**
     * 初始化报警日志
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initDayAlarmLog () {
        return self::getClass()->initDayAlarmLog();
    }

    /**
     * 主动触发-自动发送预计修图量通知
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendDayPhotoThroughputNotice () {
        return self::getClass()->sendDayPhotoThroughputNotice();
    }

    /**
     * 触发堆单检查
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoAlarmCheck () {
        return self::getClass()->photoAlarmCheck();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}