<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookCloudRetouchQueueNightLengthByParams(array $params)
 * @method hookCloudWaitRetouchPhotoCountByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听晚上十点云端蓝标单量,如果为0则云端全体成员完成目标
     *
     * @support  int $blue 蓝标单长度 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudRetouchQueueNightLength () {
        return self::getClass()->hookCloudRetouchQueueNightLength();
    }

    /**
     * 监听早上八点云端蓝标单量，如果有单则，照片算入今天的上传照片数
     *
     * @support  int $leave_photo_num 剩余照片张数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudWaitRetouchPhotoCount () {
        return self::getClass()->hookCloudWaitRetouchPhotoCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}