<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method testGetWsUsersByParams(array $params)
 * @method initPhotoNumGoalBaseDataByParams(array $params)
 * @method mockStaffScheduleByParams(array $params)
 * @method mockEditStaffScheduleByParams(array $params)
 * @method reCalculateByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取WS列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function testGetWsUsers () {
        return self::getClass()->testGetWsUsers();
    }

    /**
     * 初始化员工绩效目标数据 temp接口
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initPhotoNumGoalBaseData (string $date) {
        return self::getClass()->initPhotoNumGoalBaseData([
            "date" => $date,
        ]);
    }

    /**
     * mock考勤数据---测试用
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mockStaffSchedule (string $date) {
        return self::getClass()->mockStaffSchedule([
            "date" => $date,
        ]);
    }

    /**
     * mock考勤数据---测试用
     *
     * @support  string $date 日期 [ require true ]
     * @support  array $staffIds idArray [ require true ]
     * @support  bool $onDuty 是否上班 
     * @support  bool $workOutside 是否外勤 
     * @support  bool $workOverTime 是否加班 
     * @support  float $leaveDuration 请假时长 [Original type double] 
     * @support  int $baseGoalLevel 基础目标张数,等级 1，2是新人,中间按表排列, 8是大师修修兽 9是缦图,影响修图标准与是否为新人 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function mockEditStaffSchedule () {
        return self::getClass()->mockEditStaffSchedule();
    }

    /**
     * 核算接口
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reCalculate (string $date) {
        return self::getClass()->reCalculate([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}