<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Achievement;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setRetouchGroupGoalTodayByParams(array $params)
 * @method getRetouchGroupGoalsByDateByParams(array $params)
 */
class RetouchGroupGoal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 云端小组每日目标张数设定
     *
     * @param  int $groupId 对应日期小组目标张数 [Original type uint] [ require true ]
     * @param  int $num 对应日期小组目标张数 [Original type uint] [ require true ]
     * @param  string $date 对应日期小组目标张数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setRetouchGroupGoalToday (int $groupId, string $date, int $num) {
        return self::getClass()->setRetouchGroupGoalToday([
            "groupId" => $groupId,
            "date" => $date,
            "num" => $num,
        ]);
    }

    /**
     * 获取云端小组目标列表
     *
     * @param  string $date 对应日期小组目标张数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetouchGroupGoalsByDate (string $date) {
        return self::getClass()->getRetouchGroupGoalsByDate([
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Achievement\RetouchGroupGoal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Achievement\RetouchGroupGoal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}