<?php
namespace Mainto\Bridge\Invokes\ProjectCloudOa\Achievement;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getRetoucherGoalsByParams(array $params)
 * @method editRetoucherGoalByParams(array $params)
 * @method getTotalRetoucherGoalByParams(array $params)
 * @method getGoalByStaffIdByParams(array $params)
 */
class RetoucherGoal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 组员修图目标-列表
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRetoucherGoals (string $date) {
        return self::getClass()->getRetoucherGoals([
            "date" => $date,
        ]);
    }

    /**
     * 组员修图目标-修改组内目标值
     *
     * @param  array $staff 小伙伴目标值 [ require true ]
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editRetoucherGoal (array $staff, string $date) {
        return self::getClass()->editRetoucherGoal([
            "staff" => $staff,
            "date" => $date,
        ]);
    }

    /**
     * 组员修图目标-今日目标统计
     *
     * @param  string $date 日期 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTotalRetoucherGoal (string $date) {
        return self::getClass()->getTotalRetoucherGoal([
            "date" => $date,
        ]);
    }

    /**
     * 获取小伙伴今日目标值
     *
     * @param  string $date 日期 [ require true ]
     * @param  int $staff_id staffId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGoalByStaffId (int $staff_id, string $date) {
        return self::getClass()->getGoalByStaffId([
            "staff_id" => $staff_id,
            "date" => $date,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCloudOa', 'Achievement\RetoucherGoal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCloudOa', 'Achievement\RetoucherGoal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}