<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-26 14:38:38
 */
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class PackageRule
 * @method listPackageByStoreByParams(array $params) 获取某家门店可展示的套餐列表
 * @method listPackageByAreaByParams(array $params) 获取某价格区可展示的套餐列表
 * @method listPackageByTypeProductByParams(array $params) 获取某个产品可展示的套餐列表
 * @method listPackageByTypeProductsByParams(array $params) 获取某些产品可展示的套餐列表
 * @method listPackageByTypeProductsByAreaByParams(array $params) 获取某些产品可展示的套餐列表(通过价格区)
 * @method listPackageByProductsByParams(array $params) 获取某个产品可展示的套餐列表
 * @method listPackageByProductsByAreaByParams(array $params) 获取某个产品可展示的套餐列表(通过价格区)
 * @method getPackageRuleByParams(array $params) 获取某个套餐的规则
 * @method getPackageRuleByAreaByParams(array $params) 获取某个套餐的规则(通过价格区)
 * @method filterProductInOnlineByParams(array $params) 筛选在上架套餐中的产品
 * @method filterServiceInOnlineByParams(array $params) 筛选在上架套餐中的服务(精确匹配)
 * @method listStoreIdsBySubPackageIdsByParams(array $params) 通过子套餐ids获取可售卖门店
 * @method listProductInfoBySubPackageIdsByParams(array $params) 通过子套餐ids获取可售卖产品规则
 * @method getSubPackagesMaxPriceByParams(array $params) 获取一批子套餐中的最高价
 * @method getSubPackagesMaxPriceInSomeAreaIdsByParams(array $params) 获取一批子套餐在多个价格区中的价格
 */
class PackageRule {
    private static string $serviceName = "Product";

    private static string $className = "Package\\PackageRule";

    /**
     * 获取某家门店可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByStore (int $storeId, bool $simple = true, bool $price = false, array $filterPackageIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByStore(["storeId" => $storeId, "simple" => $simple, "price" => $price, "filterPackageIds" => $filterPackageIds]);
    }

    /**
     * 获取某价格区可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByArea (int $areaId, bool $simple = true, bool $price = false, array $filterPackageIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByArea(["areaId" => $areaId, "simple" => $simple, "price" => $price, "filterPackageIds" => $filterPackageIds]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByTypeProduct (int $storeId, string $type, int $id, bool $simple = true, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProduct(["storeId" => $storeId, "type" => $type, "id" => $id, "simple" => $simple, "price" => $price]);
    }

    /**
     * 获取某些产品可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByTypeProducts (int $storeId, string $type, array $ids, bool $simple = true, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProducts(["storeId" => $storeId, "type" => $type, "ids" => $ids, "simple" => $simple, "price" => $price]);
    }

    /**
     * 获取某些产品可展示的套餐列表(通过价格区)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByTypeProductsByArea (int $areaId, string $type, array $ids, bool $simple = true, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProductsByArea(["areaId" => $areaId, "type" => $type, "ids" => $ids, "simple" => $simple, "price" => $price]);
    }

    /**
     * 获取某个产品可展示的套餐列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByProducts (int $storeId, array $productIds, bool $simple = true, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByProducts(["storeId" => $storeId, "productIds" => $productIds, "simple" => $simple, "price" => $price]);
    }

    /**
     * 获取某个产品可展示的套餐列表(通过价格区)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listPackageByProductsByArea (int $areaId, array $productIds, bool $simple = true, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByProductsByArea(["areaId" => $areaId, "productIds" => $productIds, "simple" => $simple, "price" => $price]);
    }

    /**
     * 获取某个套餐的规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPackageRule (int $storeId, int $packageId, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageRule(["storeId" => $storeId, "packageId" => $packageId, "price" => $price]);
    }

    /**
     * 获取某个套餐的规则(通过价格区)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getPackageRuleByArea (int $areaId, int $packageId, bool $price = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageRuleByArea(["areaId" => $areaId, "packageId" => $packageId, "price" => $price]);
    }

    /**
     * 筛选在上架套餐中的产品
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function filterProductInOnline (array $productIds, string $type = 'photography') {
        return RpcClass::getClass(self::$serviceName, self::$className)->filterProductInOnline(["productIds" => $productIds, "type" => $type]);
    }

    /**
     * 筛选在上架套餐中的服务(精确匹配)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function filterServiceInOnline (array $serviceIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->filterServiceInOnline(["serviceIds" => $serviceIds]);
    }

    /**
     * 通过子套餐ids获取可售卖门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listStoreIdsBySubPackageIds (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listStoreIdsBySubPackageIds(["subPackageIds" => $subPackageIds]);
    }

    /**
     * 通过子套餐ids获取可售卖产品规则
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function listProductInfoBySubPackageIds (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listProductInfoBySubPackageIds(["subPackageIds" => $subPackageIds]);
    }

    /**
     * 获取一批子套餐中的最高价
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSubPackagesMaxPrice (array $subPackageIds, array $areaIds, bool $calcPeopleNumMax = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackagesMaxPrice(["subPackageIds" => $subPackageIds, "areaIds" => $areaIds, "calcPeopleNumMax" => $calcPeopleNumMax]);
    }

    /**
     * 获取一批子套餐在多个价格区中的价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSubPackagesMaxPriceInSomeAreaIds (array $subPackageIds, array $areaIds, bool $calcPeopleNumMax = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackagesMaxPriceInSomeAreaIds(["subPackageIds" => $subPackageIds, "areaIds" => $areaIds, "calcPeopleNumMax" => $calcPeopleNumMax]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}