<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-08-21 15:15:41
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Cache
 * @method hookAddProductByParams(array $params) hookAddProduct
 * @method hookUpdateProductByParams(array $params) hookUpdateProduct
 * @method hookChangeBlacklistByParams(array $params) hookChangeBlacklist
 * @method hookChangePriceAreaWithStoreByParams(array $params) hookChangePriceAreaWithStore
 * @method hookUpdateCategoryByParams(array $params) hookUpdateCategory
 * @method hookChangePriceWithAreaByParams(array $params) hookChangePriceWithArea
 * @method hookChangeProductWithPriceByParams(array $params) hookChangeProductWithPrice
 * @method hookPackageUpByParams(array $params) hookPackageUp
 * @method hookPackageUpdateByParams(array $params) hookPackageUpdate
 * @method hookPackageDownByParams(array $params) hookPackageDown
 * @method hookChangeClassificationStoreByParams(array $params) hookChangeClassificationStore
 * @method hookProductServiceGroupUpdateByParams(array $params) hookProductServiceGroupUpdate
 * @method hookDiscountRuleUpdateByParams(array $params) hookDiscountRuleUpdate
 * @method hookServiceUpdateByParams(array $params) hookServiceUpdate
 * @method cronSetCacheByParams(array $params) 定时缓存信息
 * @method cronCacheOverrideByParams(array $params) 定时重建缓存信息
 * @method rebuildDelayCacheByParams(array $params) 重建缓存
 * @method warmUpCacheByParams(array $params) 预热缓存
 * @method getAllCacheDelayByParams(array $params) 获取当前缓存key
 * @method clearCacheTagByParams(array $params) 清除指定tag缓存
 * @method clearCacheByPatternByParams(array $params) 清除指定缓存
 * @method batchClearCacheDelayByParams(array $params) 清除指定缓存队列 key
 * @method cronCheckAndUpdateIndexByParams(array $params) 定时更新索引
 * @method checkAndUpdateIndexByParams(array $params) 更新索引
 */
class Cache {
    private static string $serviceName = "Product";

    private static string $className = "Cache";

    /**
     * hookAddProduct
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookAddProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookAddProduct(["productId" => $productId]);
    }

    /**
     * hookUpdateProduct
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookUpdateProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUpdateProduct(["productId" => $productId]);
    }

    /**
     * hookChangeBlacklist
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookChangeBlacklist (array $productIds, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangeBlacklist(["productIds" => $productIds, "storeIds" => $storeIds]);
    }

    /**
     * hookChangePriceAreaWithStore
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookChangePriceAreaWithStore (int $priceAreaId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangePriceAreaWithStore(["priceAreaId" => $priceAreaId, "storeIds" => $storeIds]);
    }

    /**
     * hookUpdateCategory
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookUpdateCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookUpdateCategory(["categoryId" => $categoryId]);
    }

    /**
     * hookChangePriceWithArea
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookChangePriceWithArea (int $priceId, array $areaIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangePriceWithArea(["priceId" => $priceId, "areaIds" => $areaIds]);
    }

    /**
     * hookChangeProductWithPrice
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookChangeProductWithPrice (int $productId, int $priceId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangeProductWithPrice(["productId" => $productId, "priceId" => $priceId]);
    }

    /**
     * hookPackageUp
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookPackageUp (int $packageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookPackageUp(["packageId" => $packageId]);
    }

    /**
     * hookPackageUpdate
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookPackageUpdate (int $packageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookPackageUpdate(["packageId" => $packageId]);
    }

    /**
     * hookPackageDown
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookPackageDown (int $packageId, array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookPackageDown(["packageId" => $packageId, "subPackageIds" => $subPackageIds]);
    }

    /**
     * hookChangeClassificationStore
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookChangeClassificationStore (int $classificationId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookChangeClassificationStore(["classificationId" => $classificationId, "storeIds" => $storeIds]);
    }

    /**
     * hookProductServiceGroupUpdate
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookProductServiceGroupUpdate (int $serviceGroupId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookProductServiceGroupUpdate(["serviceGroupId" => $serviceGroupId]);
    }

    /**
     * hookDiscountRuleUpdate
     * @return  mixed
    */
    public static function hookDiscountRuleUpdate () {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookDiscountRuleUpdate();
    }

    /**
     * hookServiceUpdate
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function hookServiceUpdate (int $serviceId, int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->hookServiceUpdate(["serviceId" => $serviceId, "productId" => $productId]);
    }

    /**
     * 定时缓存信息
     * @return  mixed
    */
    public static function cronSetCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSetCache();
    }

    /**
     * 定时重建缓存信息
     * @return  mixed
    */
    public static function cronCacheOverride () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCacheOverride();
    }

    /**
     * 重建缓存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function rebuildDelayCache (bool $force = false, string $keyPrefix = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rebuildDelayCache(["force" => $force, "keyPrefix" => $keyPrefix]);
    }

    /**
     * 预热缓存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function warmUpCache (string $keyPrefix = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->warmUpCache(["keyPrefix" => $keyPrefix]);
    }

    /**
     * 获取当前缓存key
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAllCacheDelay (bool $onlyNeedKey = true, bool $filterTime = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllCacheDelay(["onlyNeedKey" => $onlyNeedKey, "filterTime" => $filterTime]);
    }

    /**
     * 清除指定tag缓存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function clearCacheTag (string $tagName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCacheTag(["tagName" => $tagName]);
    }

    /**
     * 清除指定缓存
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function clearCacheByPattern (string $pattern, string $connection = 'cache', bool $usePrefix = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCacheByPattern(["pattern" => $pattern, "connection" => $connection, "usePrefix" => $usePrefix]);
    }

    /**
     * 清除指定缓存队列 key
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function batchClearCacheDelay (array $keyArr) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchClearCacheDelay(["keyArr" => $keyArr]);
    }

    /**
     * 定时更新索引
     * @return  mixed
    */
    public static function cronCheckAndUpdateIndex () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronCheckAndUpdateIndex();
    }

    /**
     * 更新索引
     * @return  mixed
    */
    public static function checkAndUpdateIndex () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkAndUpdateIndex();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}