<?php
namespace Mainto\Bridge\Enums\Product\Package;

class PackageStatusEnum {
    /**
     * 未上架
     */
    const INIT = 'init';
    /**
     * 已下架
     */
    const DOWN = 'down';
    /**
     * 已上架
     */
    const UP = 'up';
    /**
     * 自动上架失败
     */
    const AUTOMATIC_UP_FAIL = 'automatic_up_fail';
    /**
     * 自动下架失败
     */
    const AUTOMATIC_DOWN_FAIL = 'automatic_down_fail';
    /**
     * 自动上架管理中
     */
    const AUTOMATIC_UP = 'automatic_up';
    /**
     * 自动下架管理中
     */
    const AUTOMATIC_DOWN = 'automatic_down';
    /**
     * 全部
     */
    const GROUP_ALL = [0 => 'init',1 => 'down',2 => 'up',3 => 'automatic_up_fail',4 => 'automatic_down_fail',5 => 'automatic_up',6 => 'automatic_down'];
    /**
     * 自动管理的状态
     */
    const GROUP_AUTOMATIC = [0 => 'automatic_up',1 => 'automatic_down'];
    /**
     * 可以进行上架的状态
     */
    const GROUP_CAN_UP = [0 => 'init',1 => 'automatic_up'];
    /**
     * 可以进行下架的状态
     */
    const GROUP_CAN_DOWN = [0 => 'init',1 => 'up',2 => 'automatic_up_fail',3 => 'automatic_down_fail',4 => 'automatic_up',5 => 'automatic_down'];
    /**
     * 会进行预约端展示的套餐
     */
    const GROUP_CAN_SHOW = [0 => 'up',1 => 'automatic_down',2 => 'automatic_down_fail'];
}