<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreDiscountByParams(array $params)
 * @method addProductDiscountRuleByParams(array $params)
 * @method productDiscountDetailByParams(array $params)
 * @method getDiscountByIdsByParams(array $params)
 * @method getProductDiscountListByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  bool $add_hour 是否包含一个小时内将会开始的活动 [ require false ]
     * @param  bool $include_hidden 是否包含隐藏的rule [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreDiscount (int $store_id, bool $add_hour = true, bool $include_hidden = false) {
        return self::getClass()->getStoreDiscount([
            "store_id" => $store_id,
            "add_hour" => $add_hour,
            "include_hidden" => $include_hidden,
        ]);
    }

    /**
     * 新建计算折扣规则
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [ require false ]
     * @support  string $group 分组（是否可与优惠券共用） [ require true ]
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [ require true ]
     * @support  array $rule 优惠规则 [ require true ]
     * @support  string $start_time 折扣开始时间 [ require false ]
     * @support  string $end_time 折扣结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductDiscountRule () {
        return self::getClass()->addProductDiscountRule([
        ]);
    }

    /**
     * 获取折扣详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDiscountDetail (int $id) {
        return self::getClass()->productDiscountDetail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取优惠
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDiscountByIds (array $ids) {
        return self::getClass()->getDiscountByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * O1 分页方式, 使用limit和fromId进行分页
     *
     * @param  int $page 当前页 [ require false ]
     * @param  int $page_size 页内条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductDiscountList (int $page = 1, int $page_size = 20) {
        return self::getClass()->getProductDiscountList([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 删除折扣
     *
     * @param  int $discount_id 折扣id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDiscount (int $discount_id) {
        return self::getClass()->deleteDiscount([
            "discount_id" => $discount_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}