<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailInStoreByParams(array $params)
 * @method updateByParams(array $params)
 * @method setCHiddenByParams(array $params)
 * @method getDetailByIdsByParams(array $params)
 * @method deleteByParams(array $params)
 * @method upByParams(array $params)
 * @method offByParams(array $params)
 * @method getStoreProductsByParams(array $params)
 * @method getPriceInAreaByParams(array $params)
 * @method setDeadlineByParams(array $params)
 * @method blacklistStoreIdsByParams(array $params)
 * @method multiBlacklistStoreIdsByParams(array $params)
 * @method blacklistsByParams(array $params)
 * @method addStoreToBlacklistByParams(array $params)
 * @method batchStoreAddProductToBlacklistByParams(array $params)
 * @method getStoreListByHaveBlacklistByParams(array $params)
 * @method getBlacklistByStoreIdByParams(array $params)
 * @method removeStoreFromBlacklistByParams(array $params)
 * @method getServiceByIdsByParams(array $params)
 * @method getNameByParams(array $params)
 * @method getFullNameByParams(array $params)
 * @method getServiceIdsByTypeOrProductIdsByParams(array $params)
 * @method getServiceFullNameByParams(array $params)
 * @method canSendImageToCloudServiceByIdsByParams(array $params)
 * @method getProductTreeByIdsByParams(array $params)
 * @method getProductTreeByModuleByParams(array $params)
 * @method getPhotographicNumByParams(array $params)
 * @method getStoreProductTreeByParams(array $params)
 * @method getProductsByStoreIdCategoryIdsByParams(array $params)
 * @method getProductsByStoreIdCategoryIdByParams(array $params)
 * @method getStoreAllProductByParams(array $params)
 * @method haveSameProductsAndServicesStoreByParams(array $params)
 * @method haveSameProductProductStoreByParams(array $params)
 * @method haveSomeProductStoreByParams(array $params)
 * @method getProductsInStoreByParams(array $params)
 * @method getProductInStoreByParams(array $params)
 * @method serviceGroupsByParams(array $params)
 * @method serviceLabelsByParams(array $params)
 * @method addServiceGroupByParams(array $params)
 * @method editServiceGroupByParams(array $params)
 * @method addServiceLabelByParams(array $params)
 * @method getProductAndServiceByStoreIdsByParams(array $params)
 * @method updateExtendByParams(array $params)
 * @method getCategoryIdsByStoreIdsByParams(array $params)
 * @method getServiceIdsByProductIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品列表
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  string $full_name 全称(模糊查询) [ require false ]
     * @support  array $module 所属模块 [ require false ]
     * @support  int $category_id 分类ID [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  bool $c_hidden 预约端是否隐藏 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * 产品列表分页
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  string $full_name 全称(模糊查询) [ require false ]
     * @support  array $module 所属模块 [ require false ]
     * @support  int $category_id 分类ID [ require false ]
     * @support  bool $show_deleted 是否显示已删除信息 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  bool $c_hidden 预约端是否隐藏 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 新增产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $module 模块 [ require true ]
     * @support  int $category_id 类目 ID [ require false ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  string $main_img 产品主图 [ require true ]
     * @support  string $full_name 全称 [ require false ]
     * @support  int $mini_people_num 最小适配人数 [ require false ]
     * @support  int $max_people_num 最大适配人数 [ require false ]
     * @support  int $photographic_num 可上传拍摄照片数量 [ require false ]
     * @support  int $photo_num 照片张数 [ require false ]
     * @support  int $occupy_value 占点设置 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  string $deadline 预约截止时间 [ require false ]
     * @support  bool $is_entity 是否是零售产品 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  array $extend 产品展示信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 门店产品详情(带价格)
     *
     * @param  int $id id [ require true ]
     * @support  int $store_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailInStore (int $id) {
        return self::getClass()->detailInStore([
            "id" => $id,
        ]);
    }

    /**
     * 编辑产品
     *
     * @param  int $id id [ require true ]
     * @support  string $name 产品名称 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  int $category_id P ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  string $main_img 产品主图 [ require false ]
     * @support  string $full_name 全称 [ require false ]
     * @support  int $mini_people_num 最小适配人数 [ require false ]
     * @support  int $max_people_num 最大适配人数 [ require false ]
     * @support  int $photographic_num 可上传拍摄照片数量 [ require false ]
     * @support  int $photo_num 照片张数 [ require false ]
     * @support  int $occupy_value 占点设置 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  string $deadline 预约截止时间 [ require false ]
     * @support  bool $is_entity 是否是零售产品 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  array $extend 产品展示信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 设置预约端显示/隐藏
     *
     * @param  int $id 产品ID [ require true ]
     * @param  bool $hiddenInClient 是否预约端隐藏 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCHidden (int $id, bool $hiddenInClient = false) {
        return self::getClass()->setCHidden([
            "id" => $id,
            "hiddenInClient" => $hiddenInClient,
        ]);
    }

    /**
     * 批量获取产品基础信息详情
     *
     * @param  array $ids 产品id集 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetailByIds (array $ids) {
        return self::getClass()->getDetailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 上架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function up (int $id) {
        return self::getClass()->up([
            "id" => $id,
        ]);
    }

    /**
     * 下架一个产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function off (int $id) {
        return self::getClass()->off([
            "id" => $id,
        ]);
    }

    /**
     * 获取门店下面的产品信息
     * @deprecated
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  int $show_level 起始类目等级 [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @support  bool $with_price 是否带上产品价格/false [ require false ]
     * @support  bool $with_services 是否带上服务/false [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreProducts () {
        return self::getClass()->getStoreProducts([
        ]);
    }

    /**
     * 获取产品在某个价格区下面的价格
     *
     * @param  int $id 产品ID [ require true ]
     * @support  int $price_area_id 价格区id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPriceInArea (int $id) {
        return self::getClass()->getPriceInArea([
            "id" => $id,
        ]);
    }

    /**
     * 设置预约截止时间
     *
     * @param  int $id 产品ID [ require true ]
     * @support  string $deadline 预约截止时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setDeadline (int $id) {
        return self::getClass()->setDeadline([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function blacklistStoreIds (int $id) {
        return self::getClass()->blacklistStoreIds([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店列表，多个交集
     *
     * @param  array $ids 多个产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function multiBlacklistStoreIds (array $ids) {
        return self::getClass()->multiBlacklistStoreIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 产品禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function blacklists (int $id) {
        return self::getClass()->blacklists([
            "id" => $id,
        ]);
    }

    /**
     * 产品禁用门店, 返回更新后的禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @support  array $store_ids 门店ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addStoreToBlacklist (int $id) {
        return self::getClass()->addStoreToBlacklist([
            "id" => $id,
        ]);
    }

    /**
     * 批量对门店操作黑名单(新增,移除,重置)
     *
     * @param  array $ids 产品IDs [ require false ]
     * @param  array $store_ids 门店ids [ require true ]
     * @param  string $handle_type 操作类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchStoreAddProductToBlacklist (string $handle_type, array $store_ids, array $ids = []) {
        return self::getClass()->batchStoreAddProductToBlacklist([
            "handle_type" => $handle_type,
            "store_ids" => $store_ids,
            "ids" => $ids,
        ]);
    }

    /**
     * 获取禁用产品的门店列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreListByHaveBlacklist () {
        return self::getClass()->getStoreListByHaveBlacklist();
    }

    /**
     * 根据门店查询禁用产品列表
     *
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBlacklistByStoreId (int $store_id) {
        return self::getClass()->getBlacklistByStoreId([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 移除黑名单中的门店, 返回更新后的禁用门店列表
     *
     * @param  int $id 产品ID [ require true ]
     * @support  array $store_ids 门店ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeStoreFromBlacklist (int $id) {
        return self::getClass()->removeStoreFromBlacklist([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取服务详情
     *
     * @param  array $ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceByIds (array $ids) {
        return self::getClass()->getServiceByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取名称
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getName (array $ids) {
        return self::getClass()->getName([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取全称
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFullName (array $ids) {
        return self::getClass()->getFullName([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取服务ids
     *
     * @param  string $type 服务type [ require true ]
     * @param  array $product_ids 服务ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceIdsByTypeOrProductIds (string $type = 'cloud_send_image', array $product_ids = null) {
        return self::getClass()->getServiceIdsByTypeOrProductIds([
            "type" => $type,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 批量获取服务全称
     *
     * @param  array $ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceFullName (array $ids) {
        return self::getClass()->getServiceFullName([
            "ids" => $ids,
        ]);
    }

    /**
     * 获取云端传图类服务
     *
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function canSendImageToCloudServiceByIds (array $ids) {
        return self::getClass()->canSendImageToCloudServiceByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 根据产品ids获取产品树
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @param  string $status 产品状态（默认上架） [ require false ]
     * @param  int $show_level 起始类目等级 [ require false ]
     * @param  bool $c_hidden 是否包含预约端隐藏 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductTreeByIds (array $product_ids, string $status = 'all', int $show_level = 0, bool $c_hidden = false) {
        return self::getClass()->getProductTreeByIds([
            "product_ids" => $product_ids,
            "status" => $status,
            "show_level" => $show_level,
            "c_hidden" => $c_hidden,
        ]);
    }

    /**
     * 获取根类目产品树
     *
     * @support  array $module 所属模块数组 [ require false ]
     * @support  string $status 产品状态（默认上架） [ require false ]
     * @support  bool $c_hidden 是否包含预约端隐藏 [ require false ]
     * @support  int $show_level 起始类目等级 [ require false ]
     * @support  bool $reject_no_products_category 排除没有产品的类目 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductTreeByModule () {
        return self::getClass()->getProductTreeByModule([
        ]);
    }

    /**
     * 获取可上传摄影数量
     * @deprecated
     *
     * @param  int $pid 产品ID [ require true ]
     * @param  int $sid 升级服务ID [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotographicNum (int $pid, int $sid = 0) {
        return self::getClass()->getPhotographicNum([
            "pid" => $pid,
            "sid" => $sid,
        ]);
    }

    /**
     * 获取门店产品树
     * @deprecated
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  int $show_level 起始类目等级 [ require false ]
     * @param  string $status 产品状态（默认上架） [ require false ]
     * @param  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @param  bool $with_price 是否带上产品价格/false [ require false ]
     * @param  bool $reject_no_products_category 排除没有产品的类目 [ require false ]
     * @param  bool $with_services 是否带上服务/true [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreProductTree (int $store_id, int $show_level = 1, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $reject_no_products_category = false, bool $with_services = true) {
        return self::getClass()->getStoreProductTree([
            "store_id" => $store_id,
            "show_level" => $show_level,
            "status" => $status,
            "c_hidden" => $c_hidden,
            "with_price" => $with_price,
            "reject_no_products_category" => $reject_no_products_category,
            "with_services" => $with_services,
        ]);
    }

    /**
     * 获取门店某些类目下所有产品
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  array $category_ids 类目ids [ require true ]
     * @param  string $module 所属产品线 [ require false ]
     * @param  string $status 产品状态（默认上架） [ require false ]
     * @param  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @param  bool $with_price 是否带上产品价格/false [ require false ]
     * @param  bool $with_category 是否带上类目信息/true [ require false ]
     * @param  bool $with_services 是否带上服务信息/true [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsByStoreIdCategoryIds (int $store_id, array $category_ids, string $module = 'himo_blue', string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return self::getClass()->getProductsByStoreIdCategoryIds([
            "store_id" => $store_id,
            "category_ids" => $category_ids,
            "module" => $module,
            "status" => $status,
            "c_hidden" => $c_hidden,
            "with_price" => $with_price,
            "with_category" => $with_category,
            "with_services" => $with_services,
        ]);
    }

    /**
     * 获取门店某个类目下所有产品
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  int $category_id 类目ID [ require true ]
     * @param  string $status 产品状态（默认上架） [ require false ]
     * @param  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @param  bool $with_price 是否带上产品价格/false [ require false ]
     * @param  bool $with_category 是否带上类目信息/true [ require false ]
     * @param  bool $with_services 是否带上服务信息/true [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsByStoreIdCategoryId (int $store_id, int $category_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return self::getClass()->getProductsByStoreIdCategoryId([
            "store_id" => $store_id,
            "category_id" => $category_id,
            "status" => $status,
            "c_hidden" => $c_hidden,
            "with_price" => $with_price,
            "with_category" => $with_category,
            "with_services" => $with_services,
        ]);
    }

    /**
     * 获取门店所有产品, 适当传参, 带上类目和服务会慢
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $status 产品状态（默认上架） [ require false ]
     * @param  bool $c_hidden 是否预约端隐藏 [ require false ]
     * @param  bool $with_price 是否带上产品价格/false [ require false ]
     * @param  bool $with_category 是否带上类目信息/true [ require false ]
     * @param  bool $with_services 是否带上服务信息/true [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreAllProduct (int $store_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return self::getClass()->getStoreAllProduct([
            "store_id" => $store_id,
            "status" => $status,
            "c_hidden" => $c_hidden,
            "with_price" => $with_price,
            "with_category" => $with_category,
            "with_services" => $with_services,
        ]);
    }

    /**
     * 筛选出同有某些产品和升级服务的一些门店
     *
     * @param  array $store_ids 门店ID [ require false ]
     * @param  array $products 产品和升级服务 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveSameProductsAndServicesStore (array $store_ids = [], array $products = []) {
        return self::getClass()->haveSameProductsAndServicesStore([
            "store_ids" => $store_ids,
            "products" => $products,
        ]);
    }

    /**
     * 筛选出同有某个产品的一些门店
     *
     * @param  array $store_ids 门店ID [ require false ]
     * @param  array $product_ids 产品ID数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveSameProductProductStore (array $store_ids = [], array $product_ids = []) {
        return self::getClass()->haveSameProductProductStore([
            "store_ids" => $store_ids,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 筛选出同有某些产品中部分的一些门店
     *
     * @param  array $store_ids 门店ID [ require false ]
     * @param  array $product_ids 产品ID数组 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function haveSomeProductStore (array $store_ids = [], array $product_ids = []) {
        return self::getClass()->haveSomeProductStore([
            "store_ids" => $store_ids,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 获取门店多个产品详情
     *
     * @param  array $product_ids 产品ID数组 [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductsInStore (array $product_ids, int $store_id) {
        return self::getClass()->getProductsInStore([
            "product_ids" => $product_ids,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 查询门店的一个产品（含在该门店的价格）
     *
     * @param  int $product_id 产品ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductInStore (int $product_id, int $store_id) {
        return self::getClass()->getProductInStore([
            "product_id" => $product_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 批量获取全部服务组
     * @deprecated
     *
     * @param  array $ids 服务组ID数组（不传则返回全部） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceGroups (array $ids = []) {
        return self::getClass()->serviceGroups([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量获取全部服务项
     * @deprecated
     *
     * @param  array $ids 服务项ID数组（不传则返回全部） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceLabels (array $ids = []) {
        return self::getClass()->serviceLabels([
            "ids" => $ids,
        ]);
    }

    /**
     * 创建一个服务组
     * @deprecated
     *
     * @support  string $name 服务组名称 [ require true ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  string $full_name 全称 [ require false ]
     * @support  bool $multiple 是否支持多选 [ require true ]
     * @support  bool $is_required 是否必选 [ require true ]
     * @support  array $extend 扩展字段 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addServiceGroup () {
        return self::getClass()->addServiceGroup([
        ]);
    }

    /**
     * 编辑升级服务组
     * @deprecated
     *
     * @support  int $id id [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  string $full_name 全称 [ require false ]
     * @support  bool $multiple 是否支持多选 [ require false ]
     * @support  bool $is_required 是否必填 [ require false ]
     * @support  array $extend 扩展字段 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editServiceGroup () {
        return self::getClass()->editServiceGroup([
        ]);
    }

    /**
     * 创建一个服务项（存在同名则返回同名的那个）
     * @deprecated
     *
     * @param  string $name 服务label名称 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addServiceLabel (string $name) {
        return self::getClass()->addServiceLabel([
            "name" => $name,
        ]);
    }

    /**
     * 批量获取多个门店产品服务信息
     *
     * @param  array $store_ids 门店ids [ require true ]
     * @param  bool $hidden_no_price 是否隐藏没价格产品 [ require false ]
     * @param  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductAndServiceByStoreIds (array $store_ids, bool $hidden_no_price = false, string $status = 'on') {
        return self::getClass()->getProductAndServiceByStoreIds([
            "store_ids" => $store_ids,
            "hidden_no_price" => $hidden_no_price,
            "status" => $status,
        ]);
    }

    /**
     * 更新产品展示信息
     *
     * @param  int $id 产品ID [ require true ]
     * @param  array $extend 展示信息array [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExtend (int $id, array $extend) {
        return self::getClass()->updateExtend([
            "id" => $id,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取门店下的类目ids
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryIdsByStoreIds () {
        return self::getClass()->getCategoryIdsByStoreIds([
        ]);
    }

    /**
     * 根据产品ID获取必选服务ID
     *
     * @support  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceIdsByProductIds () {
        return self::getClass()->getServiceIdsByProductIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}