<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductPriceByParams(array $params)
 * @method getProductJxjyPriceByParams(array $params)
 * @method getMaxPriceByParams(array $params)
 */
class ProductCalc {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 计算产品价格并返回计算详情
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  array $detail 购买信息的数组, 示例详见文档 [ require true ]
     * @param  bool $include_delete 是否包含隐藏 [ require true ]
     * @param  array $sub_package_ids 所使用的子套餐ID [ require true ]
     * @param  array $special_discounts 特殊的优惠规则 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductPrice (int $store_id, array $detail, bool $include_delete = false, array $sub_package_ids = [], array $special_discounts = []) {
        return self::getClass()->getProductPrice([
            "store_id" => $store_id,
            "detail" => $detail,
            "include_delete" => $include_delete,
            "sub_package_ids" => $sub_package_ids,
            "special_discounts" => $special_discounts,
        ]);
    }

    /**
     * 包含宫格优惠
     *
     * @param  int $storeId 门店ID [ require true ]
     * @param  int $productId 服务ID [ require true ]
     * @param  int $productPeopleNum 拍摄产品选则的人数 [ require true ]
     * @param  array $nowInfo 需要信息 [ require true ]
     * @param  bool $includeDelete 是否包含隐藏 [ require true ]
     * @param  array $oriInfo 原信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductJxjyPrice (int $storeId, int $productId, array $nowInfo, array $oriInfo = [], bool $includeDelete = false, int $productPeopleNum = 0) {
        return self::getClass()->getProductJxjyPrice([
            "storeId" => $storeId,
            "productId" => $productId,
            "nowInfo" => $nowInfo,
            "oriInfo" => $oriInfo,
            "includeDelete" => $includeDelete,
            "productPeopleNum" => $productPeopleNum,
        ]);
    }

    /**
     * 计算一批产品的最贵价格
     *
     * @param  array $areaIds 限定计算的价格区 [ require true ]
     * @param  array $products 产品数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaxPrice (array $areaIds, array $products) {
        return self::getClass()->getMaxPrice([
            "areaIds" => $areaIds,
            "products" => $products,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCalc');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCalc');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}