<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByIdByParams(array $params)
 * @method getStartTagsByIdsAndUseTypeByParams(array $params)
 * @method getTreeByStatusAndUseTypeAndIdByParams(array $params)
 * @method pageListByParams(array $params)
 * @method getDataByParentIdByParams(array $params)
 * @method existsNameByParentIdAndNameByParams(array $params)
 * @method startTagByIdsByParams(array $params)
 * @method startTagByIdByParams(array $params)
 * @method closeTagByIdsByParams(array $params)
 * @method getOneByIdAndNameAndParentIdByParams(array $params)
 * @method getOneOrFailByIdByParams(array $params)
 * @method getDataByUseTypeAndIdsByParams(array $params)
 * @method getOneByIdByParams(array $params)
 * @method getDataByIdsByParams(array $params)
 */
class PictureTag {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建标签
     *
     * @support  int $parentId 父id require false
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 require false
     * @support  string $description 描述 require false
     * @support  string $parentPath 父级路径 require false
     * @support  int $level 标签级别 require false
     * @throws  \Exception
     * @return  int
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新标签
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  int $parentId 父id require false
     * @support  string $name 标签名称 [ require true ]
     * @support  int $weight 权重 require false
     * @support  string $description 描述 require false
     * @support  string $parent_path 父级路径 require false
     * @support  int $level 标签级别 require false
     * @throws  \Exception
     * @return  array
     */
    public static function updateById () {
        return self::getClass()->updateById();
    }

    /**
     * 获取开启的标签，通过ids和使用类型
     *
     * @support  array $tagIds 标签ids [ require true ]
     * @support  string $useType 使用类型 [ require true ]
     * @support  array $fields 显示字段 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getStartTagsByIdsAndUseType () {
        return self::getClass()->getStartTagsByIdsAndUseType();
    }

    /**
     * 获取树结构，通过状态、使用类型和标签id
     *
     * @support  string $status 状态 require false
     * @support  string $useType 使用类型 [ require true ]
     * @support  int $tagId 标签id require false
     * @support  array $fields 显示字段 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getTreeByStatusAndUseTypeAndId () {
        return self::getClass()->getTreeByStatusAndUseTypeAndId();
    }

    /**
     * 分页列表
     *
     * @support  int $tagId 标签id require false
     * @support  int $page 页码 require false
     * @support  int $page_size 每页条数 require false
     * @support  string $useType 使用类型，默认样片池标签 require false
     * @throws  \Exception
     * @return  array
     */
    public static function pageList () {
        return self::getClass()->pageList();
    }

    /**
     * 通过parentId获取数据
     *
     * @support  int $parentId 父id [ require true ]
     * @support  array $fields 显示字段 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getDataByParentId () {
        return self::getClass()->getDataByParentId();
    }

    /**
     * 检查同父级下的标签名称是否存在
     *
     * @support  int $parentId 父id [ require true ]
     * @support  string $name 标签名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function existsNameByParentIdAndName () {
        return self::getClass()->existsNameByParentIdAndName();
    }

    /**
     * 通过tagIds开启标签
     *
     * @support  array $tagIds 标签ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startTagByIds () {
        return self::getClass()->startTagByIds();
    }

    /**
     * 通过tagId开启标签
     *
     * @support  int $tagId 标签ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function startTagById () {
        return self::getClass()->startTagById();
    }

    /**
     * 通过tagIds关闭标签
     *
     * @support  array $tagIds 标签ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeTagByIds () {
        return self::getClass()->closeTagByIds();
    }

    /**
     * 得到一个标签，通过id、name、parent_id
     *
     * @support  int $tagId 标签id [ require true ]
     * @support  string $name 标签名称 [ require true ]
     * @support  int $parentId 父标签id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOneByIdAndNameAndParentId () {
        return self::getClass()->getOneByIdAndNameAndParentId();
    }

    /**
     * 得到标签详情,如果不存在就抛异常
     *
     * @support  int $tagId 标签ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOneOrFailById () {
        return self::getClass()->getOneOrFailById();
    }

    /**
     * 通过useType 和ids获取数据
     *
     * @support  array $tagIds 标签id [ require true ]
     * @support  string $useType 使用类型，默认样片池标签 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDataByUseTypeAndIds () {
        return self::getClass()->getDataByUseTypeAndIds();
    }

    /**
     * 得到标签详情
     *
     * @support  int $tagId 标签id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOneById () {
        return self::getClass()->getOneById();
    }

    /**
     * 通过tagIds批量获取数据
     *
     * @support  array $tagIds 标签ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDataByIds () {
        return self::getClass()->getDataByIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'PictureTag');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'PictureTag');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}