<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-11-26 14:37:37
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class StoreProductTree
 * @method treeByParams(array $params) 根据不同参数获取门店产品树
 * @method getByParams(array $params) 获取门店产品树
 * @method getByPriceAreaByParams(array $params) 获取价格区产品树
 * @method getManyByParams(array $params) 获取多个门店的产品树
 */
class StoreProductTree {
    private static string $serviceName = "Product";

    private static string $className = "StoreProductTree";

    /**
     * 根据不同参数获取门店产品树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function tree (int $store_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->tree(array_merge($_params, ["store_id" => $store_id]));
    }

    /**
     * 获取门店产品树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function get (int $store_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->get(array_merge($_params, ["store_id" => $store_id]));
    }

    /**
     * 获取价格区产品树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getByPriceArea (int $area_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByPriceArea(array_merge($_params, ["area_id" => $area_id]));
    }

    /**
     * 获取多个门店的产品树
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getMany (array $store_ids, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMany(array_merge($_params, ["store_ids" => $store_ids]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}