<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-07 11:29:09
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Price
 * @method createByParams(array $params) 创建产品价格
 * @method deleteGonggeByParams(array $params) 取消宫格
 * @method deleteJxjyByParams(array $params) 取消加修加印
 * @method detailByParams(array $params) 产品价格详情
 * @method updateByParams(array $params) 更新产品价格
 * @method deleteByParams(array $params) 删除产品价格
 * @method getListByProductIdByParams(array $params) 获取产品所有价格信息
 * @method changePriceAreaByParams(array $params) 更换价格区
 * @method batchBindPriceAreaByParams(array $params) 批量新绑价格区
 * @method unbindPriceAreaByParams(array $params) 解绑价格区
 */
class Price {
    private static string $serviceName = "Product";

    private static string $className = "Price";

    /**
     * 创建产品价格
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }

    /**
     * 取消宫格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteGongge (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteGongge(["id" => $id]);
    }

    /**
     * 取消加修加印
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteJxjy (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteJxjy(["id" => $id]);
    }

    /**
     * 产品价格详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }

    /**
     * 更新产品价格
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function update (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(array_merge($_params, ["id" => $id]));
    }

    /**
     * 删除产品价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 获取产品所有价格信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getListByProductId (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getListByProductId($_params);
    }

    /**
     * 更换价格区
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function changePriceArea (int $id, int $new_price_area_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePriceArea(array_merge($_params, ["id" => $id, "new_price_area_id" => $new_price_area_id]));
    }

    /**
     * 批量新绑价格区
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function batchBindPriceArea (int $id, array $new_price_area_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchBindPriceArea(["id" => $id, "new_price_area_ids" => $new_price_area_ids]);
    }

    /**
     * 解绑价格区
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function unbindPriceArea (int $id, int $price_area_id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->unbindPriceArea(array_merge($_params, ["id" => $id, "price_area_id" => $price_area_id]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}