<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-01-06 16:43:37
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductCalc
 * @method getProductPriceByParams(array $params) 计算产品价格并返回计算详情
 * @method getProductPriceByPriceAreaByParams(array $params) 计算产品价格并返回计算详情(使用价格区)
 * @method getProductJxjyPriceByParams(array $params) 计算产品加修加印价格
 * @method getMaxPriceByParams(array $params) 计算一批产品的最贵价格
 * @method getWeekdayDiscountByParams(array $params) 计算周间价并返回计算详情
 */
class ProductCalc {
    private static string $serviceName = "Product";

    private static string $className = "ProductCalc";

    /**
     * 计算产品价格并返回计算详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductPrice (int $store_id, array $detail, bool $include_delete = false, array $sub_package_ids = [], array $special_discounts = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductPrice(["store_id" => $store_id, "detail" => $detail, "include_delete" => $include_delete, "sub_package_ids" => $sub_package_ids, "special_discounts" => $special_discounts]);
    }

    /**
     * 计算产品价格并返回计算详情(使用价格区)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductPriceByPriceArea (int $area_id, array $detail, bool $include_delete = false, array $sub_package_ids = [], array $special_discounts = [], bool $need_product_split = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductPriceByPriceArea(["area_id" => $area_id, "detail" => $detail, "include_delete" => $include_delete, "sub_package_ids" => $sub_package_ids, "special_discounts" => $special_discounts, "need_product_split" => $need_product_split]);
    }

    /**
     * 计算产品加修加印价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getProductJxjyPrice (int $storeId, int $productId, array $nowInfo, array $oriInfo = [], bool $includeDelete = false, int $productPeopleNum = 0, string $jxjyAdjustNo = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductJxjyPrice(["storeId" => $storeId, "productId" => $productId, "nowInfo" => $nowInfo, "oriInfo" => $oriInfo, "includeDelete" => $includeDelete, "productPeopleNum" => $productPeopleNum, "jxjyAdjustNo" => $jxjyAdjustNo]);
    }

    /**
     * 计算一批产品的最贵价格
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getMaxPrice (array $areaIds, array $products) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaxPrice(["areaIds" => $areaIds, "products" => $products]);
    }

    /**
     * 计算周间价并返回计算详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getWeekdayDiscount (int $storeId, array $detail, float $totalPrice, string $reserveDay, array $specialDiscountIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWeekdayDiscount(["storeId" => $storeId, "detail" => $detail, "totalPrice" => $totalPrice, "reserveDay" => $reserveDay, "specialDiscountIds" => $specialDiscountIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}