<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-11 18:20:42
 */
namespace Mainto\Bridge\Invokes\Product\ProductOccupy;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class ProductOccupy
 * @method getOccupyNumByParams(array $params) 获取排单表占点
 * @method batchGetOccupyNumByParams(array $params) 批量获取排单表占点
 * @method clearProductCacheByParams(array $params) clearProductCache
 * @method cronSetProductCacheByParams(array $params) 定时缓存产品基础信息
 */
class ProductOccupy {
    private static string $serviceName = "Product";

    private static string $className = "ProductOccupy\\ProductOccupy";

    /**
     * 获取排单表占点
     * @return  mixed
    */
    public static function getOccupyNum (\Mainto\Bridge\Structs\Product\ProductOccupy\Command\OccupyNumCommand $occupyNumCommand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOccupyNum($occupyNumCommand);
    }

    /**
     * 批量获取排单表占点
     * @return  array
    */
    public static function batchGetOccupyNum (\Mainto\Bridge\Structs\Product\ProductOccupy\Command\BatchOccupyNumCommand $batchOccupyNumCommand) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->batchGetOccupyNum($batchOccupyNumCommand),
            "\Mainto\Bridge\Structs\Product\ProductOccupy\DTO\BatchOccupyNumDTO[]"
        );
    }

    /**
     * clearProductCache
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function clearProductCache (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearProductCache(["productId" => $productId]);
    }

    /**
     * 定时缓存产品基础信息
     * @return  mixed
    */
    public static function cronSetProductCache () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronSetProductCache();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}