<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-02-11 18:20:42
 */
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class SubPackage
 * @method createSubPackageByParams(array $params) 创建一个子套餐
 * @method editSubPackageByParams(array $params) 编辑子套餐
 * @method getSubPackageByParams(array $params) 获取子套餐详情
 * @method getSubPackagesByParams(array $params) 批量获取子套餐详情
 * @method getSubPackageBindStoreByParams(array $params) 获得子套餐可视门店
 * @method deleteSubPackageByParams(array $params) 子套餐删除
 * @method rebuildSubPackageRelationByParams(array $params) 重建关联
 * @method cronRebuildSubPackageRelationByParams(array $params) 定时重建套餐关联
 * @method getSubPackageByProductIdsByParams(array $params) 获取含某些产品的子套餐
 * @method compareSubPackageByParams(array $params) 比较子套餐信息
 */
class SubPackage {
    private static string $serviceName = "Product";

    private static string $className = "Package\\SubPackage";

    /**
     * 创建一个子套餐
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function createSubPackage (int $packageId, string $name, \Mainto\Bridge\Structs\Product\Package\SubPackage\CreateSubPackageParamsMetadata $metadata, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSubPackage(["packageId" => $packageId, "name" => $name, "metadata" => $metadata, "extend" => $extend]);
    }

    /**
     * 编辑子套餐
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function editSubPackage (int $subPackageId, string $name = null, array $metadata = null, array $extend = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSubPackage(["subPackageId" => $subPackageId, "name" => $name, "metadata" => $metadata, "extend" => $extend]);
    }

    /**
     * 获取子套餐详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSubPackage (int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackage(["subPackageId" => $subPackageId]);
    }

    /**
     * 批量获取子套餐详情
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSubPackages (array $subPackageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackages(["subPackageIds" => $subPackageIds]);
    }

    /**
     * 获得子套餐可视门店
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getSubPackageBindStore (int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackageBindStore(["subPackageId" => $subPackageId]);
    }

    /**
     * 子套餐删除
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function deleteSubPackage (int $subPackageId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSubPackage(["subPackageId" => $subPackageId]);
    }

    /**
     * 重建关联
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function rebuildSubPackageRelation (string $module, bool $syncStore = false, bool $syncPhotographyProduct = false, bool $syncRetailProduct = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->rebuildSubPackageRelation(["module" => $module, "syncStore" => $syncStore, "syncPhotographyProduct" => $syncPhotographyProduct, "syncRetailProduct" => $syncRetailProduct]);
    }

    /**
     * 定时重建套餐关联
     * @return  mixed
    */
    public static function cronRebuildSubPackageRelation () {
        return RpcClass::getClass(self::$serviceName, self::$className)->cronRebuildSubPackageRelation();
    }

    /**
     * 获取含某些产品的子套餐
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getSubPackageByProductIds (array $productIds, array $filterStoreIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackageByProductIds(["productIds" => $productIds, "filterStoreIds" => $filterStoreIds]);
    }

    /**
     * 比较子套餐信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function compareSubPackage (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->compareSubPackage($_params);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}