<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-01-15 14:01:58
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductDiscount
 */
class ProductDiscount {
    private static string $serviceName = "Product";

    private static string $className = "ProductDiscount";

    /**
     * 获取门店折扣规则
     * @return  mixed
    */
    public static function getStoreDiscount (int $store_id, bool $add_hour = true, bool $include_hidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreDiscount(["store_id" => $store_id, "add_hour" => $add_hour, "include_hidden" => $include_hidden]);
    }
    /**
     * 获取多个门店折扣规则
     * @return  mixed
    */
    public static function getStoreIdsDiscount (array $storeIds, bool $addHour = true, bool $includeHidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsDiscount(["storeIds" => $storeIds, "addHour" => $addHour, "includeHidden" => $includeHidden]);
    }
    /**
     * 新建计算折扣规则
     * @return  mixed
    */
    public static function addProductDiscountRule (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addProductDiscountRule($_params);
    }
    /**
     * 获取折扣详情
     * @return  mixed
    */
    public static function productDiscountDetail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDiscountDetail(["id" => $id]);
    }
    /**
     * 批量获取优惠
     * @return  mixed
    */
    public static function getDiscountByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDiscountByIds(["ids" => $ids]);
    }
    /**
     * 折扣列表
     * @return  mixed
    */
    public static function getProductDiscountList (int $page = 1, int $page_size = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDiscountList(["page" => $page, "page_size" => $page_size]);
    }
    /**
     * 删除折扣
     * @return  mixed
    */
    public static function deleteDiscount (int $discount_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteDiscount(["discount_id" => $discount_id]);
    }
    /**
     * 获取周间价时间范围
     * @return  mixed
    */
    public static function getWeekdayDiscountRange (int $storeId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWeekdayDiscountRange(["storeId" => $storeId]);
    }
    /**
     * 获取历史所有周间价规则ids
     * @return  mixed
    */
    public static function getAllWeekdayDiscountIds () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllWeekdayDiscountIds();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}