<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-12-04 13:42:24
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCategory
 */
class ProductCategory {
    private static string $serviceName = "Product";

    private static string $className = "ProductCategory";

    /**
     * 类目列表
     * @return  mixed
    */
    public static function all (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all($_params);
    }
    /**
     * 获取类目下面的所有零售产品信息-拍摄产品的同级别的零售产品
     * @return  mixed
    */
    public static function getRetailProducts (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRetailProducts(["categoryId" => $categoryId]);
    }
    /**
     * 类目列表分页
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list($_params);
    }
    /**
     * 新增类目
     * @return  mixed
    */
    public static function create (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($_params);
    }
    /**
     * 类目详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 类目基本信息（包含删除）
     * @return  array
    */
    public static function baseInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->baseInfo(["id" => $id]);
    }
    /**
     * 删除类目
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 编辑类目
     * @return  mixed
    */
    public static function update (int $id, string $name, string $module, int $parentId, string $engName, string $fullName, int $sort, bool $multiple, string $comment, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "module" => $module, "parentId" => $parentId, "engName" => $engName, "fullName" => $fullName, "sort" => $sort, "multiple" => $multiple, "comment" => $comment, "extend" => $extend]);
    }
    /**
     * 删除类目
     * @return  mixed
    */
    public static function remove (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->remove(["id" => $id]);
    }
    /**
     * 更改状态
     * @return  mixed
    */
    public static function updateStatus (int $id, string $status) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateStatus(["id" => $id, "status" => $status]);
    }
    /**
     * 绑定上级类目
     * @return  mixed
    */
    public static function bindParent (int $id, int $parentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindParent(["id" => $id, "parentId" => $parentId]);
    }
    /**
     * 扁平获取下级子类
     * @return  mixed
    */
    public static function getChild (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChild(["id" => $id]);
    }
    /**
     * 获取树状类目
     * @return  mixed
    */
    public static function getCategoryTree (int $show_level = 0, string $status = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryTree(["show_level" => $show_level, "status" => $status]);
    }
    /**
     * 开启/关闭类目下所有产品的预约端显示（不包括服务）
     * @return  bool
    */
    public static function setCHiddenNested (int $id, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCHiddenNested(["id" => $id, "c_hidden" => $c_hidden]);
    }
    /**
     * 改变类目下的下一级sort大于等于指定值的子节点的排序
     * @return  mixed
    */
    public static function changeNodesSort (int $id, int $num, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeNodesSort(["id" => $id, "num" => $num, "sort" => $sort]);
    }
    /**
     * 改变类目下的下一级sort大于指定值的产品的排序
     * @return  mixed
    */
    public static function changeProductNodesSort (int $id, int $num, int $sort) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeProductNodesSort(["id" => $id, "num" => $num, "sort" => $sort]);
    }
    /**
     * 获取对应门店类目下面的服装信息
     * @return  mixed
    */
    public static function getClothesInStore (int $id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getClothesInStore(["id" => $id, "store_id" => $store_id]);
    }
    /**
     * 更新产品展示信息
     * @return  mixed
    */
    public static function updateExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateExtend(["id" => $id, "extend" => $extend]);
    }
    /**
     * 获取有某标签的产品组id
     * @return  mixed
    */
    public static function getCategoryHaveTag (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryHaveTag(["tagId" => $tagId]);
    }
    /**
     * 获取含某标签组其中之一的产品组ids集合
     * @return  mixed
    */
    public static function getCategoryHaveTags (array $tagIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryHaveTags(["tagIds" => $tagIds]);
    }
    /**
     * 获取某些类目下的产品和价格
     * @return  mixed
    */
    public static function batchCategoryWithProductAndPrice (array $categoryIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCategoryWithProductAndPrice(["categoryIds" => $categoryIds]);
    }
    /**
     * 获取该类目下的产品和价格
     * @return  mixed
    */
    public static function getCategoryWithProductAndServicePrice (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryWithProductAndServicePrice(["categoryId" => $categoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}