<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-23 15:06:05
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PictureTag
 */
class PictureTag {
    private static string $serviceName = "Product";

    private static string $className = "PictureTag";

    /**
     * 创建标签
     * @return  int
    */
    public static function create (int $parentId = 0, string $name, int $weight = 0, string $description = '', string $parentPath = '/', int $level = 0, string $useType = 'sample_pool') {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["parentId" => $parentId, "name" => $name, "weight" => $weight, "description" => $description, "parentPath" => $parentPath, "level" => $level, "useType" => $useType]);
    }
    /**
     * 更新标签
     * @return  array
    */
    public static function updateById (int $tagId, int $parentId = 0, string $name, int $weight = 0, string $description = '', string $parent_path = '/', int $level = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateById(["tagId" => $tagId, "parentId" => $parentId, "name" => $name, "weight" => $weight, "description" => $description, "parent_path" => $parent_path, "level" => $level]);
    }
    /**
     * 获取开启的标签，通过ids和使用类型
     * @return  array
    */
    public static function getStartTagsByIdsAndUseType (array $tagIds, string $useType, array $fields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStartTagsByIdsAndUseType(["tagIds" => $tagIds, "useType" => $useType, "fields" => $fields]);
    }
    /**
     * 获取树结构，通过状态、使用类型和标签id
     * @return  array
    */
    public static function getTreeByStatusAndUseTypeAndId (string $status = '', string $useType, int $tagId, array $fields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTreeByStatusAndUseTypeAndId(["status" => $status, "useType" => $useType, "tagId" => $tagId, "fields" => $fields]);
    }
    /**
     * 获取树结构，通过状态、使用类型
     * @return  array
    */
    public static function getTreeByStatusAndUseType (string $status = '', string $useType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTreeByStatusAndUseType(["status" => $status, "useType" => $useType]);
    }
    /**
     * 分页列表
     * @return  array
    */
    public static function pageList (int $tagId, int $page = 1, int $page_size = 15, string $useType = 'sample_pool') {
        return RpcClass::getClass(self::$serviceName, self::$className)->pageList(["tagId" => $tagId, "page" => $page, "page_size" => $page_size, "useType" => $useType]);
    }
    /**
     * 通过parentId获取数据
     * @return  array
    */
    public static function getDataByParentId (int $parentId, array $fields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDataByParentId(["parentId" => $parentId, "fields" => $fields]);
    }
    /**
     * 通过parentId获取数据
     * @return  array
    */
    public static function getDataByParentIdAndUseType (int $parentId, string $useType = 'sample_pool', array $fields) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDataByParentIdAndUseType(["parentId" => $parentId, "useType" => $useType, "fields" => $fields]);
    }
    /**
     * 检查同父级下的标签名称是否存在
     * @return  bool
    */
    public static function existsNameByParentIdAndName (int $parentId, string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->existsNameByParentIdAndName(["parentId" => $parentId, "name" => $name]);
    }
    /**
     * 通过tagIds开启标签
     * @return  bool
    */
    public static function startTagByIds (array $tagIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->startTagByIds(["tagIds" => $tagIds]);
    }
    /**
     * 通过tagId开启标签
     * @return  bool
    */
    public static function startTagById (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->startTagById(["tagId" => $tagId]);
    }
    /**
     * 通过tagIds关闭标签
     * @return  bool
    */
    public static function closeTagByIds (array $tagIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeTagByIds(["tagIds" => $tagIds]);
    }
    /**
     * 得到一个标签，通过id、name、parent_id
     * @return  array
    */
    public static function getOneByIdAndNameAndParentId (int $tagId, string $name, int $parentId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOneByIdAndNameAndParentId(["tagId" => $tagId, "name" => $name, "parentId" => $parentId]);
    }
    /**
     * 得到标签详情,如果不存在就抛异常
     * @return  array
    */
    public static function getOneOrFailById (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOneOrFailById(["tagId" => $tagId]);
    }
    /**
     * 通过useType 和ids获取数据
     * @return  array
    */
    public static function getDataByUseTypeAndIds (array $tagIds, string $useType = 'sample_pool') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDataByUseTypeAndIds(["tagIds" => $tagIds, "useType" => $useType]);
    }
    /**
     * 得到标签详情
     * @return  array
    */
    public static function getOneById (int $tagId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOneById(["tagId" => $tagId]);
    }
    /**
     * 通过tagIds批量获取数据
     * @return  array
    */
    public static function getDataByIds (array $tagIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDataByIds(["tagIds" => $tagIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}