<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-10-20 14:01:32
 */
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "Product";

    private static string $className = "Product";

    /**
     * 产品列表
     * @return  mixed
    */
    public static function all (string $name, string $full_name, array $module, int $category_id, bool $show_deleted, string $status, bool $c_hidden, bool $is_style) {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name, "full_name" => $full_name, "module" => $module, "category_id" => $category_id, "show_deleted" => $show_deleted, "status" => $status, "c_hidden" => $c_hidden, "is_style" => $is_style]);
    }
    /**
     * 产品列表分页
     * @return  mixed
    */
    public static function list (string $name, string $full_name, array $module, int $category_id, bool $show_deleted, string $status, bool $c_hidden, int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "full_name" => $full_name, "module" => $module, "category_id" => $category_id, "show_deleted" => $show_deleted, "status" => $status, "c_hidden" => $c_hidden, "page" => $page, "page_size" => $page_size]);
    }
    /**
     * 新增产品
     * @return  mixed
    */
    public static function create (string $name, string $module, int $category_id, string $eng_name, string $main_img, string $full_name, int $mini_people_num = 1, int $max_people_num = 1, int $photographic_num, int $photo_num = 0, int $negative_num = 0, int $set_num = 1, int $occupy_value = 1, bool $can_upload_cloud, int $sort, bool $c_hidden, string $deadline, bool $is_entity, string $comment, array $extend, \Mainto\Bridge\Structs\Product\Product\CreateParamsMetadata $metadata) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "module" => $module, "category_id" => $category_id, "eng_name" => $eng_name, "main_img" => $main_img, "full_name" => $full_name, "mini_people_num" => $mini_people_num, "max_people_num" => $max_people_num, "photographic_num" => $photographic_num, "photo_num" => $photo_num, "negative_num" => $negative_num, "set_num" => $set_num, "occupy_value" => $occupy_value, "can_upload_cloud" => $can_upload_cloud, "sort" => $sort, "c_hidden" => $c_hidden, "deadline" => $deadline, "is_entity" => $is_entity, "comment" => $comment, "extend" => $extend, "metadata" => $metadata]);
    }
    /**
     * 产品详情
     * @return  mixed
    */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id]);
    }
    /**
     * 产品基本信息（包含删除）
     * @return  array
    */
    public static function baseInfo (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->baseInfo(["id" => $id]);
    }
    /**
     * 门店产品详情(带价格)
     * @return  mixed
    */
    public static function detailInStore (int $id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailInStore(["id" => $id, "store_id" => $store_id]);
    }
    /**
     * 编辑产品
     * @return  mixed
    */
    public static function update (int $id, string $name, string $module, int $category_id, string $status, string $eng_name, string $main_img, string $full_name, int $mini_people_num, int $max_people_num, int $photographic_num, int $photo_num, int $occupy_value, int $negative_num, int $set_num, bool $can_upload_cloud, array $retail_product_ids, int $sort, bool $c_hidden, string $deadline, bool $is_entity, string $comment, array $extend, \Mainto\Bridge\Structs\Product\Product\UpdateParamsMetadata $metadata) {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "module" => $module, "category_id" => $category_id, "status" => $status, "eng_name" => $eng_name, "main_img" => $main_img, "full_name" => $full_name, "mini_people_num" => $mini_people_num, "max_people_num" => $max_people_num, "photographic_num" => $photographic_num, "photo_num" => $photo_num, "occupy_value" => $occupy_value, "negative_num" => $negative_num, "set_num" => $set_num, "can_upload_cloud" => $can_upload_cloud, "retail_product_ids" => $retail_product_ids, "sort" => $sort, "c_hidden" => $c_hidden, "deadline" => $deadline, "is_entity" => $is_entity, "comment" => $comment, "extend" => $extend, "metadata" => $metadata]);
    }
    /**
     * 设置预约端显示/隐藏
     * @return  array
    */
    public static function setCHidden (int $id, bool $hiddenInClient = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCHidden(["id" => $id, "hiddenInClient" => $hiddenInClient]);
    }
    /**
     * 批量获取产品基础信息详情
     * @return  mixed
    */
    public static function getDetailByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailByIds(["ids" => $ids]);
    }
    /**
     * 批量获取产品详情(带价格区)
     * @return  mixed
    */
    public static function getDetailByIdsWithPriceAreas (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getDetailByIdsWithPriceAreas(["ids" => $ids]);
    }
    /**
     * 删除产品
     * @return  mixed
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 上架一个产品
     * @return  mixed
    */
    public static function up (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->up(["id" => $id]);
    }
    /**
     * 下架一个产品
     * @return  array
    */
    public static function off (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->off(["id" => $id]);
    }
    /**
     * 批量上架产品
     * @return  mixed
    */
    public static function batchUp (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUp(["ids" => $ids]);
    }
    /**
     * 批量下架产品
     * @return  mixed
    */
    public static function batchOff (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchOff(["ids" => $ids]);
    }
    /**
     * 批量显示/隐藏产品
     * @return  mixed
    */
    public static function batchChangeHidden (array $ids, bool $hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchChangeHidden(["ids" => $ids, "hidden" => $hidden]);
    }
    /**
     * 获取门店下面的产品信息
     * @return  mixed
    */
    public static function getStoreProducts (array $store_ids, int $show_level, string $status, bool $c_hidden, bool $with_price, bool $with_services) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProducts(["store_ids" => $store_ids, "show_level" => $show_level, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_services" => $with_services]);
    }
    /**
     * 获取产品在某个价格区下面的价格
     * @return  mixed
    */
    public static function getPriceInArea (int $id, int $price_area_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPriceInArea(["id" => $id, "price_area_id" => $price_area_id]);
    }
    /**
     * 设置预约截止时间
     * @return  mixed
    */
    public static function setDeadline (int $id, string $deadline) {
        return RpcClass::getClass(self::$serviceName, self::$className)->setDeadline(["id" => $id, "deadline" => $deadline]);
    }
    /**
     * 产品禁用门店列表
     * @return  mixed
    */
    public static function blacklistStoreIds (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->blacklistStoreIds(["id" => $id]);
    }
    /**
     * 产品禁用门店列表，多个交集
     * @return  array
    */
    public static function multiBlacklistStoreIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->multiBlacklistStoreIds(["ids" => $ids]);
    }
    /**
     * 产品禁用门店列表
     * @return  mixed
    */
    public static function blacklists (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->blacklists(["id" => $id]);
    }
    /**
     * 产品禁用门店, 返回更新后的禁用门店列表
     * @return  mixed
    */
    public static function addStoreToBlacklist (int $id, array $store_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToBlacklist(["id" => $id, "store_ids" => $store_ids]);
    }
    /**
     * 批量对门店操作黑名单(新增,移除,重置)
     * @return  mixed
    */
    public static function batchStoreAddProductToBlacklist (string $handle_type, array $store_ids, array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchStoreAddProductToBlacklist(["handle_type" => $handle_type, "store_ids" => $store_ids, "ids" => $ids]);
    }
    /**
     * 获取门店禁用产品数量&amp;可拍产品数量
     * @return  mixed
    */
    public static function getStoreListByHaveBlacklist () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByHaveBlacklist();
    }
    /**
     * 根据门店查询禁用产品列表
     * @return  mixed
    */
    public static function getBlacklistByStoreId (int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlacklistByStoreId(["store_id" => $store_id]);
    }
    /**
     * 批量根据门店查询禁用产品列表
     * @return  mixed
    */
    public static function getBlacklistByStoreIds (array $store_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getBlacklistByStoreIds(["store_ids" => $store_ids]);
    }
    /**
     * 移除黑名单中的门店, 返回更新后的禁用门店列表
     * @return  mixed
    */
    public static function removeStoreFromBlacklist (int $id, array $store_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeStoreFromBlacklist(["id" => $id, "store_ids" => $store_ids]);
    }
    /**
     * 批量获取服务详情
     * @return  mixed
    */
    public static function getServiceByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceByIds(["ids" => $ids]);
    }
    /**
     * 批量获取名称
     * @return  mixed
    */
    public static function getName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getName(["ids" => $ids]);
    }
    /**
     * 批量获取全称
     * @return  mixed
    */
    public static function getFullName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getFullName(["ids" => $ids]);
    }
    /**
     * 批量获取服务ids
     * @return  mixed
    */
    public static function getServiceIdsByTypeOrProductIds (string $type = 'cloud_send_image', array $product_ids = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceIdsByTypeOrProductIds(["type" => $type, "product_ids" => $product_ids]);
    }
    /**
     * 批量获取服务全称
     * @return  mixed
    */
    public static function getServiceFullName (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceFullName(["ids" => $ids]);
    }
    /**
     * 获取云端传图类服务
     * @return  mixed
    */
    public static function canSendImageToCloudServiceByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->canSendImageToCloudServiceByIds(["ids" => $ids]);
    }
    /**
     * 根据产品ids获取产品树
     * @return  mixed
    */
    public static function getProductTreeByIds (array $product_ids, string $status = 'all', int $show_level = 0, bool $c_hidden = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByIds(["product_ids" => $product_ids, "status" => $status, "show_level" => $show_level, "c_hidden" => $c_hidden]);
    }
    /**
     * 获取根类目产品树
     * @return  mixed
    */
    public static function getProductTreeByModule (array $module, string $status, bool $c_hidden, int $show_level, bool $reject_no_products_category, array $node_type, bool $is_entity, bool $no_cache) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductTreeByModule(["module" => $module, "status" => $status, "c_hidden" => $c_hidden, "show_level" => $show_level, "reject_no_products_category" => $reject_no_products_category, "node_type" => $node_type, "is_entity" => $is_entity, "no_cache" => $no_cache]);
    }
    /**
     * 获取可上传摄影数量
     * @return  mixed
    */
    public static function getPhotographicNum (int $pid, int $sid = 0) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotographicNum(["pid" => $pid, "sid" => $sid]);
    }
    /**
     * 获取门店产品树
     * @return  mixed
    */
    public static function getStoreProductTree (int $store_id, int $show_level = 1, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $reject_no_products_category = false, bool $with_services = true, string $order_by_sort = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreProductTree(["store_id" => $store_id, "show_level" => $show_level, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "reject_no_products_category" => $reject_no_products_category, "with_services" => $with_services, "order_by_sort" => $order_by_sort]);
    }
    /**
     * 获取门店某些类目下所有产品
     * @return  array
    */
    public static function getProductsByStoreIdCategoryIds (int $store_id, array $category_ids, string $module = 'himo_blue', string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreIdCategoryIds(["store_id" => $store_id, "category_ids" => $category_ids, "module" => $module, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services]);
    }
    /**
     * 获取门店某个类目下所有产品
     * @return  mixed
    */
    public static function getProductsByStoreIdCategoryId (int $store_id, int $category_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsByStoreIdCategoryId(["store_id" => $store_id, "category_id" => $category_id, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services]);
    }
    /**
     * 获取门店所有产品, 适当传参, 带上类目和服务会慢
     * @return  mixed
    */
    public static function getStoreAllProduct (int $store_id, string $status = 'on', bool $c_hidden = false, bool $with_price = false, bool $with_category = true, bool $with_services = true, bool $is_style = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreAllProduct(["store_id" => $store_id, "status" => $status, "c_hidden" => $c_hidden, "with_price" => $with_price, "with_category" => $with_category, "with_services" => $with_services, "is_style" => $is_style]);
    }
    /**
     * 筛选出同有某些产品和升级服务的一些门店
     * @return  mixed
    */
    public static function haveSameProductsAndServicesStore (array $store_ids = [], array $products = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSameProductsAndServicesStore(["store_ids" => $store_ids, "products" => $products]);
    }
    /**
     * 筛选出同有某个产品的一些门店
     * @return  mixed
    */
    public static function haveSameProductProductStore (array $store_ids = [], array $product_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSameProductProductStore(["store_ids" => $store_ids, "product_ids" => $product_ids]);
    }
    /**
     * 筛选出同有某些产品中部分的一些门店
     * @return  mixed
    */
    public static function haveSomeProductStore (array $store_ids = [], array $product_ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->haveSomeProductStore(["store_ids" => $store_ids, "product_ids" => $product_ids]);
    }
    /**
     * 获取门店多个产品详情
     * @return  mixed
    */
    public static function getProductsInStore (array $product_ids, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsInStore(["product_ids" => $product_ids, "store_id" => $store_id]);
    }
    /**
     * 查询门店的一个产品（含在该门店的价格）
     * @return  mixed
    */
    public static function getProductInStore (int $product_id, int $store_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductInStore(["product_id" => $product_id, "store_id" => $store_id]);
    }
    /**
     * 批量获取全部服务组
     * @return  mixed
    */
    public static function serviceGroups (array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceGroups(["ids" => $ids]);
    }
    /**
     * 批量获取全部服务项
     * @return  mixed
    */
    public static function serviceLabels (array $ids = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->serviceLabels(["ids" => $ids]);
    }
    /**
     * 创建一个服务组
     * @return  mixed
    */
    public static function addServiceGroup (string $name, string $eng_name, string $full_name, bool $multiple, bool $is_required, array $extend, string $type, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceGroup(["name" => $name, "eng_name" => $eng_name, "full_name" => $full_name, "multiple" => $multiple, "is_required" => $is_required, "extend" => $extend, "type" => $type, "comment" => $comment]);
    }
    /**
     * 编辑升级服务组
     * @return  mixed
    */
    public static function editServiceGroup (int $id, string $name, string $eng_name, string $full_name, bool $multiple, bool $is_required, array $extend, string $type, string $comment) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editServiceGroup(["id" => $id, "name" => $name, "eng_name" => $eng_name, "full_name" => $full_name, "multiple" => $multiple, "is_required" => $is_required, "extend" => $extend, "type" => $type, "comment" => $comment]);
    }
    /**
     * 创建一个服务项（存在同名则返回同名的那个）
     * @return  mixed
    */
    public static function addServiceLabel (string $name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addServiceLabel(["name" => $name]);
    }
    /**
     * 批量获取多个门店产品服务信息
     * @return  mixed
    */
    public static function getProductAndServiceByStoreIds (array $store_ids, bool $hidden_no_price = false, string $status = 'on') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductAndServiceByStoreIds(["store_ids" => $store_ids, "hidden_no_price" => $hidden_no_price, "status" => $status]);
    }
    /**
     * 更新产品展示信息
     * @return  mixed
    */
    public static function updateExtend (int $id, array $extend) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateExtend(["id" => $id, "extend" => $extend]);
    }
    /**
     * 获取门店下的类目ids
     * @return  mixed
    */
    public static function getCategoryIdsByStoreIds (array $store_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryIdsByStoreIds(["store_ids" => $store_ids]);
    }
    /**
     * 根据产品ID获取必选服务ID
     * @return  mixed
    */
    public static function getServiceIdsByProductIds (array $product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getServiceIdsByProductIds(["product_ids" => $product_ids]);
    }
    /**
     * 同步产品上的标签关联
     * @return  mixed
    */
    public static function syncProductTags (int $productId, array $tagIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->syncProductTags(["productId" => $productId, "tagIds" => $tagIds]);
    }
    /**
     * 获取产品可拍摄门店
     * @return  mixed
    */
    public static function getProductsWithStores (array $productIds, array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsWithStores(["productIds" => $productIds, "storeIds" => $storeIds]);
    }
    /**
     * 获取产品组下产品可拍摄门店
     * @return  mixed
    */
    public static function getProductsWithStoresByCategory (int $categoryId, array $storeIds = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductsWithStoresByCategory(["categoryId" => $categoryId, "storeIds" => $storeIds]);
    }
    /**
     * 新店自动加入指定产品黑名单
     * @return  mixed
    */
    public static function addStoreToProductDefaultBlacklist (int $priceAreaId, array $storeIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addStoreToProductDefaultBlacklist(["priceAreaId" => $priceAreaId, "storeIds" => $storeIds]);
    }
    /**
     * 清除指定tag缓存
     * @return  mixed
    */
    public static function clearCacheTag (string $tagName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearCacheTag(["tagName" => $tagName]);
    }
    /**
     * 比较产品信息
     * @return  mixed
    */
    public static function compareProduct (int $id, int $mini_people_num, int $max_people_num, int $photo_num, array $prices) {
        return RpcClass::getClass(self::$serviceName, self::$className)->compareProduct(["id" => $id, "mini_people_num" => $mini_people_num, "max_people_num" => $max_people_num, "photo_num" => $photo_num, "prices" => $prices]);
    }
    /**
     * 比较服务信息
     * @return  mixed
    */
    public static function compareService (int $id, array $service_groups) {
        return RpcClass::getClass(self::$serviceName, self::$className)->compareService(["id" => $id, "service_groups" => $service_groups]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}