<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-03 16:32:13
 */
namespace Mainto\Bridge\Invokes\Product\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "Product";

    private static string $className = "Cloud\\Product";

    /**
     * 获取产品分页列表
     *
     */
    public static function list (int $page, int $page_size) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["page" => $page, "page_size" => $page_size, ]);
    }
    /**
     * 创建产品
     *
     */
    public static function create (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["product_id" => $product_id, ]);
    }
    /**
     * 获取产品详情
     *
     */
    public static function detail (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 批量获取产品信息
     *
     */
    public static function detailByIds (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailByIds(["ids" => $ids, ]);
    }
    /**
     * 禁用产品
     *
     */
    public static function disableProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->disableProduct(["id" => $id, ]);
    }
    /**
     * 启用产品
     *
     */
    public static function enableProduct (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->enableProduct(["id" => $id, ]);
    }
    /**
     * 根据云端产品ID获取产品ID
     *
     */
    public static function getProductId (int $cloud_product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductId(["cloud_product_id" => $cloud_product_id, ]);
    }
    /**
     * 批量获取HIMO产品IDS
     *
     */
    public static function getProductIds (array $cloud_product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductIds(["cloud_product_ids" => $cloud_product_ids, ]);
    }
    /**
     * 根据产品ID获取云端产品ID
     *
     */
    public static function getCloudProductId (int $product_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProductId(["product_id" => $product_id, ]);
    }
    /**
     * 批量获取云端产品
     *
     */
    public static function getCloudProductIds (array $product_ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCloudProductIds(["product_ids" => $product_ids, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}