<?php
namespace Mainto\Bridge\Invokes\Product\Cloud;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method disableProductByParams(array $params)
 * @method enableProductByParams(array $params)
 * @method getProductIdByParams(array $params)
 * @method getProductIdsByParams(array $params)
 * @method getCloudProductIdByParams(array $params)
 * @method getCloudProductIdsByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品分页列表
     *
     * @param  int $page 当前页 [ require false ]
     * @param  int $page_size 页内条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list (int $page = 1, int $page_size = 20) {
        return self::getClass()->list([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 创建产品
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $product_id) {
        return self::getClass()->create([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取产品信息
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 禁用产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function disableProduct (int $id) {
        return self::getClass()->disableProduct([
            "id" => $id,
        ]);
    }

    /**
     * 启用产品
     *
     * @param  int $id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableProduct (int $id) {
        return self::getClass()->enableProduct([
            "id" => $id,
        ]);
    }

    /**
     * 根据云端产品ID获取产品ID
     *
     * @param  int $cloud_product_id 云端产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductId (int $cloud_product_id) {
        return self::getClass()->getProductId([
            "cloud_product_id" => $cloud_product_id,
        ]);
    }

    /**
     * 批量获取HIMO产品IDS
     *
     * @param  array $cloud_product_ids 云端产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductIds (array $cloud_product_ids) {
        return self::getClass()->getProductIds([
            "cloud_product_ids" => $cloud_product_ids,
        ]);
    }

    /**
     * 根据产品ID获取云端产品ID
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProductId (int $product_id) {
        return self::getClass()->getCloudProductId([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 批量获取云端产品
     *
     * @param  array $product_ids 产品IDS [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCloudProductIds (array $product_ids) {
        return self::getClass()->getCloudProductIds([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Cloud\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Cloud\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}