<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-15 11:58:14
 */
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class PackageRule
 */
class PackageRule {
    private static string $serviceName = "Product";

    private static string $className = "Package\\PackageRule";

    /**
     * 获取某家门店可展示的套餐列表
     *
     */
    public static function listPackageByStore (int $storeId, bool $simple, bool $price, array $filterPackageIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByStore(["storeId" => $storeId, "simple" => $simple, "price" => $price, "filterPackageIds" => $filterPackageIds, ]);
    }
    /**
     * 获取某价格区可展示的套餐列表
     *
     */
    public static function listPackageByArea (int $areaId, bool $simple, bool $price, array $filterPackageIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByArea(["areaId" => $areaId, "simple" => $simple, "price" => $price, "filterPackageIds" => $filterPackageIds, ]);
    }
    /**
     * 获取某个产品可展示的套餐列表
     *
     */
    public static function listPackageByTypeProduct (int $storeId, string $type, int $id, bool $simple, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProduct(["storeId" => $storeId, "type" => $type, "id" => $id, "simple" => $simple, "price" => $price, ]);
    }
    /**
     * 获取某些产品可展示的套餐列表
     *
     */
    public static function listPackageByTypeProducts (int $storeId, string $type, array $ids, bool $simple, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProducts(["storeId" => $storeId, "type" => $type, "ids" => $ids, "simple" => $simple, "price" => $price, ]);
    }
    /**
     * 获取某些产品可展示的套餐列表(通过价格区)
     *
     */
    public static function listPackageByTypeProductsByArea (int $areaId, string $type, array $ids, bool $simple, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByTypeProductsByArea(["areaId" => $areaId, "type" => $type, "ids" => $ids, "simple" => $simple, "price" => $price, ]);
    }
    /**
     * 获取某个产品可展示的套餐列表
     *
     */
    public static function listPackageByProducts (int $storeId, array $productIds, bool $simple, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByProducts(["storeId" => $storeId, "productIds" => $productIds, "simple" => $simple, "price" => $price, ]);
    }
    /**
     * 获取某个产品可展示的套餐列表(通过价格区)
     *
     */
    public static function listPackageByProductsByArea (int $areaId, array $productIds, bool $simple, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackageByProductsByArea(["areaId" => $areaId, "productIds" => $productIds, "simple" => $simple, "price" => $price, ]);
    }
    /**
     * 获取某个套餐的规则
     *
     */
    public static function getPackageRule (int $storeId, int $packageId, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageRule(["storeId" => $storeId, "packageId" => $packageId, "price" => $price, ]);
    }
    /**
     * 获取某个套餐的规则(通过价格区)
     *
     */
    public static function getPackageRuleByArea (int $areaId, int $packageId, bool $price): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageRuleByArea(["areaId" => $areaId, "packageId" => $packageId, "price" => $price, ]);
    }
    /**
     * 筛选在上架套餐中的产品
     *
     */
    public static function filterProductInOnline (string $type, array $productIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->filterProductInOnline(["type" => $type, "productIds" => $productIds, ]);
    }
    /**
     * 筛选在上架套餐中的服务(精确匹配)
     *
     */
    public static function filterServiceInOnline (array $serviceIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->filterServiceInOnline(["serviceIds" => $serviceIds, ]);
    }
    /**
     * 通过子套餐ids获取可售卖门店
     *
     */
    public static function listStoreIdsBySubPackageIds (array $subPackageIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listStoreIdsBySubPackageIds(["subPackageIds" => $subPackageIds, ]);
    }
    /**
     * 通过子套餐ids获取可售卖产品规则
     *
     */
    public static function listProductInfoBySubPackageIds (array $subPackageIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listProductInfoBySubPackageIds(["subPackageIds" => $subPackageIds, ]);
    }
    /**
     * 获取一批子套餐中的最高价
     *
     */
    public static function getSubPackagesMaxPrice (array $subPackageIds, array $areaIds, bool $calcPeopleNumMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackagesMaxPrice(["subPackageIds" => $subPackageIds, "areaIds" => $areaIds, "calcPeopleNumMax" => $calcPeopleNumMax, ]);
    }
    /**
     * 获取一批子套餐在多个价格区中的价格
     *
     */
    public static function getSubPackagesMaxPriceInSomeAreaIds (array $subPackageIds, array $areaIds, bool $calcPeopleNumMax) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSubPackagesMaxPriceInSomeAreaIds(["subPackageIds" => $subPackageIds, "areaIds" => $areaIds, "calcPeopleNumMax" => $calcPeopleNumMax, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}