<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-15 11:58:14
 */
namespace Mainto\Bridge\Invokes\Product\Package;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Package
 */
class Package {
    private static string $serviceName = "Product";

    private static string $className = "Package\\Package";

    /**
     * 套餐列表
     *
     */
    public static function listPackage (string $module, array $modules, string $name, array $status, int $page, array $packageIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPackage(["module" => $module, "modules" => $modules, "name" => $name, "status" => $status, "page" => $page, "packageIds" => $packageIds, ]);
    }
    /**
     * 批量获取套餐
     *
     */
    public static function allPackage (string $module, array $modules, string $name, array $status, array $packageIds, bool $withSubPackage): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->allPackage(["module" => $module, "modules" => $modules, "name" => $name, "status" => $status, "packageIds" => $packageIds, "withSubPackage" => $withSubPackage, ]);
    }
    /**
     * 获取套餐详情
     *
     */
    public static function getPackage (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackage(["id" => $id, ]);
    }
    /**
     * 创建一个套餐
     *
     */
    public static function createPackage (string $module, string $name, string $engName, array $extend, array $metadata): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->createPackage(["module" => $module, "name" => $name, "engName" => $engName, "extend" => $extend, "metadata" => $metadata, ]);
    }
    /**
     * 更新一个套餐
     *
     */
    public static function updatePackage (int $id, string $module, string $name, string $engName, array $extend, array $metadata): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackage(["id" => $id, "module" => $module, "name" => $name, "engName" => $engName, "extend" => $extend, "metadata" => $metadata, ]);
    }
    /**
     * 更新一个套餐 extend 信息
     *
     */
    public static function updatePackageExtend (int $id, array $extend, bool $merge): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackageExtend(["id" => $id, "extend" => $extend, "merge" => $merge, ]);
    }
    /**
     * 更新一个套餐上下架时间
     *
     */
    public static function updatePackageTime (int $id, string $startTime, string $endTime): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updatePackageTime(["id" => $id, "startTime" => $startTime, "endTime" => $endTime, ]);
    }
    /**
     * 清空一个套餐上下架时间
     *
     */
    public static function clearPackageTime (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->clearPackageTime(["id" => $id, ]);
    }
    /**
     * 套餐上架
     *
     */
    public static function upPackage (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->upPackage(["id" => $id, ]);
    }
    /**
     * 套餐下架
     *
     */
    public static function downPackage (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->downPackage(["id" => $id, ]);
    }
    /**
     * 套餐删除
     *
     */
    public static function deletePackage (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deletePackage(["id" => $id, ]);
    }
    /**
     * 获得套餐可视门店
     *
     */
    public static function getPackageBindStore (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPackageBindStore(["id" => $id, ]);
    }
    /**
     * 获取一批门店中存在某套餐的门店
     *
     */
    public static function getStoreIdsInPackage (int $id, array $storeIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreIdsInPackage(["id" => $id, "storeIds" => $storeIds, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}