<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method baseInfoByParams(array $params)
 * @method batchGetGroupTypeByServiceIdsByParams(array $params)
 */
class ProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建服务
     *
     * @support  int $product_id 产品ID [ require false ]
     * @support  int $service_group_id 服务组ID [ require false ]
     * @support  int $service_label_id Label ID [ require false ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  int $mini_people_num 服务最小匹配人数 [ require false ]
     * @support  int $max_people_num 服务最大匹配人数 [ require false ]
     * @support  int $photographic_num 摄影上传数量 [ require false ]
     * @support  int $occupy_value 占点设置 [ require false ]
     * @support  bool $c_hidden 预约端隐藏 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  string $main_img 主图 [ require false ]
     * @support  mixed $metadata 产品服务数据(后端使用) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新服务
     *
     * @param  int $id 服务id [ require true ]
     * @support  int $product_id 产品ID [ require false ]
     * @support  int $service_group_id 服务组ID [ require false ]
     * @support  int $service_label_id Label ID [ require false ]
     * @support  string $eng_name 英文名称 [ require false ]
     * @support  int $mini_people_num 服务最小匹配人数 [ require false ]
     * @support  int $max_people_num 服务最大匹配人数 [ require false ]
     * @support  int $photographic_num 摄影上传数量 [ require false ]
     * @support  int $occupy_value 占点设置 [ require false ]
     * @support  bool $c_hidden 预约端隐藏 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  string $main_img 主图 [ require false ]
     * @support  mixed $metadata 产品服务数据(后端使用) [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除服务
     *
     * @param  int $id 服务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 服务基本信息（包含删除）
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function baseInfo (int $id) {
        return self::getClass()->baseInfo([
            "id" => $id,
        ]);
    }

    /**
     * 批量通过服务ids获取对应服务组类型
     *
     * @param  array $ids 服务ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGetGroupTypeByServiceIds (array $ids) {
        return self::getClass()->batchGetGroupTypeByServiceIds([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}