<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method getRetailProductsByParams(array $params)
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method baseInfoByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method removeByParams(array $params)
 * @method updateStatusByParams(array $params)
 * @method bindParentByParams(array $params)
 * @method getChildByParams(array $params)
 * @method getCategoryTreeByParams(array $params)
 * @method setCHiddenNestedByParams(array $params)
 * @method changeNodesSortByParams(array $params)
 * @method changeProductNodesSortByParams(array $params)
 * @method getClothesInStoreByParams(array $params)
 * @method updateExtendByParams(array $params)
 * @method getCategoryHaveTagByParams(array $params)
 * @method getCategoryHaveTagsByParams(array $params)
 * @method batchCategoryWithProductAndPriceByParams(array $params)
 * @method getCategoryWithProductAndServicePriceByParams(array $params)
 */
class ProductCategory {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 类目列表
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  string $full_name 全称(模糊查询) [ require false ]
     * @support  array $ids ids [ require false ]
     * @support  array $module 所属模块 [ require false ]
     * @support  bool $parentId 分类ID [ require false ]
     * @support  bool $showDeleted 是否显示已删除信息 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  bool $withProductsAndServices 获取下面的产品和服务 [ require false ]
     * @support  bool $withProducts 获取下面的产品 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * 获取类目下面的所有零售产品信息-拍摄产品的同级别的零售产品
     *
     * @param  int $categoryId 分类ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRetailProducts (int $categoryId) {
        return self::getClass()->getRetailProducts([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * 类目列表分页
     *
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  string $full_name 全称(模糊查询) [ require false ]
     * @support  array $module 所属模块 [ require false ]
     * @support  int $parentId 分类ID [ require false ]
     * @support  bool $showDeleted 是否显示已删除信息 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 新增类目
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  string $module 模块 [ require true ]
     * @support  int $parentId P ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $engName 英文名称 [ require false ]
     * @support  string $fullName 全称 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  bool $multiple 是否支持多选 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  array $extend 产品类目展示信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 类目详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 类目基本信息（包含删除）
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function baseInfo (int $id) {
        return self::getClass()->baseInfo([
            "id" => $id,
        ]);
    }

    /**
     * 删除类目
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 编辑类目
     *
     * @param  int $id id [ require true ]
     * @support  string $name 产品名称 [ require false ]
     * @support  string $module 模块 [ require false ]
     * @support  int $parentId P ID [ require false ]
     * @support  string $engName 英文名称 [ require false ]
     * @support  string $fullName 全称 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @support  bool $multiple 是否支持多选 [ require false ]
     * @support  string $comment 描述 [ require false ]
     * @support  array $extend 产品类目展示信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除类目
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 更改状态
     *
     * @param  int $id 分类ID [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateStatus (int $id, string $status) {
        return self::getClass()->updateStatus([
            "id" => $id,
            "status" => $status,
        ]);
    }

    /**
     * 绑定上级类目
     *
     * @param  int $id 类目ID [ require true ]
     * @param  int $parentId 父类ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindParent (int $id, int $parentId) {
        return self::getClass()->bindParent([
            "id" => $id,
            "parentId" => $parentId,
        ]);
    }

    /**
     * 扁平获取下级子类
     *
     * @param  int $id 类目ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getChild (int $id) {
        return self::getClass()->getChild([
            "id" => $id,
        ]);
    }

    /**
     * 获取树状类目
     *
     * @param  int $show_level 起始类目等级 [ require false ]
     * @param  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryTree (int $show_level = 0, string $status = null) {
        return self::getClass()->getCategoryTree([
            "show_level" => $show_level,
            "status" => $status,
        ]);
    }

    /**
     * 开启/关闭类目下所有产品的预约端显示（不包括服务）
     *
     * @param  int $id 类目ID [ require true ]
     * @support  bool $c_hidden 是否预约端隐藏 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setCHiddenNested (int $id) {
        return self::getClass()->setCHiddenNested([
            "id" => $id,
        ]);
    }

    /**
     * 改变类目下的下一级sort大于等于指定值的子节点的排序
     *
     * @param  int $id 类目ID [ require true ]
     * @support  int $num 数值 [ require false ]
     * @support  int $sort 大于的sort值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeNodesSort (int $id) {
        return self::getClass()->changeNodesSort([
            "id" => $id,
        ]);
    }

    /**
     * 改变类目下的下一级sort大于指定值的产品的排序
     *
     * @param  int $id 类目ID [ require true ]
     * @support  int $num 数值 [ require false ]
     * @support  int $sort 大于的sort值 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeProductNodesSort (int $id) {
        return self::getClass()->changeProductNodesSort([
            "id" => $id,
        ]);
    }

    /**
     * 获取对应门店类目下面的服装信息
     *
     * @param  int $id id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClothesInStore (int $id) {
        return self::getClass()->getClothesInStore([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品展示信息
     *
     * @param  int $id 产品ID [ require true ]
     * @param  array $extend 展示信息array [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateExtend (int $id, array $extend) {
        return self::getClass()->updateExtend([
            "id" => $id,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取有某标签的产品组id
     *
     * @param  int $tagId 标签id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryHaveTag (int $tagId) {
        return self::getClass()->getCategoryHaveTag([
            "tagId" => $tagId,
        ]);
    }

    /**
     * 获取含某标签组其中之一的产品组ids集合
     *
     * @param  array $tagIds 标签ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryHaveTags (array $tagIds) {
        return self::getClass()->getCategoryHaveTags([
            "tagIds" => $tagIds,
        ]);
    }

    /**
     * 获取某些类目下的产品和价格
     *
     * @param  array $categoryIds 类目ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCategoryWithProductAndPrice (array $categoryIds) {
        return self::getClass()->batchCategoryWithProductAndPrice([
            "categoryIds" => $categoryIds,
        ]);
    }

    /**
     * 获取该类目下的产品和价格
     *
     * @param  int $categoryId 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryWithProductAndServicePrice (int $categoryId) {
        return self::getClass()->getCategoryWithProductAndServicePrice([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'ProductCategory');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'ProductCategory');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}