<?php
namespace Mainto\Bridge\Invokes\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookAddProductByParams(array $params)
 * @method hookUpdateProductByParams(array $params)
 * @method hookChangeBlacklistByParams(array $params)
 * @method hookChangePriceAreaWithStoreByParams(array $params)
 * @method hookUpdateCategoryByParams(array $params)
 * @method hookChangePriceWithAreaByParams(array $params)
 * @method hookChangeProductWithPriceByParams(array $params)
 * @method hookPackageUpByParams(array $params)
 * @method hookPackageUpdateByParams(array $params)
 * @method hookPackageDownByParams(array $params)
 * @method hookChangeClassificationStoreByParams(array $params)
 * @method hookProductServiceGroupUpdateByParams(array $params)
 * @method hookDiscountRuleUpdateByParams(array $params)
 * @method hookServiceUpdateByParams(array $params)
 * @method cronSetCacheByParams(array $params)
 */
class Cache {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hookAddProduct
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookAddProduct (int $productId) {
        return self::getClass()->hookAddProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * hookUpdateProduct
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookUpdateProduct (int $productId) {
        return self::getClass()->hookUpdateProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * hookChangeBlacklist
     *
     * @param  array $productIds 产品ids [ require true ]
     * @param  array $storeIds 门店组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangeBlacklist (array $productIds, array $storeIds) {
        return self::getClass()->hookChangeBlacklist([
            "productIds" => $productIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * hookChangePriceAreaWithStore
     *
     * @param  int $priceAreaId 价格区id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangePriceAreaWithStore (int $priceAreaId, array $storeIds) {
        return self::getClass()->hookChangePriceAreaWithStore([
            "priceAreaId" => $priceAreaId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * hookUpdateCategory
     *
     * @param  int $categoryId 产品分类id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookUpdateCategory (int $categoryId) {
        return self::getClass()->hookUpdateCategory([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * hookChangePriceWithArea
     *
     * @param  int $priceId 价格id [ require true ]
     * @param  int $areaIds 价格区ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangePriceWithArea (int $priceId, int $areaIds) {
        return self::getClass()->hookChangePriceWithArea([
            "priceId" => $priceId,
            "areaIds" => $areaIds,
        ]);
    }

    /**
     * hookChangeProductWithPrice
     *
     * @param  int $productId 产品id [ require true ]
     * @param  int $priceId 价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangeProductWithPrice (int $productId, int $priceId) {
        return self::getClass()->hookChangeProductWithPrice([
            "productId" => $productId,
            "priceId" => $priceId,
        ]);
    }

    /**
     * hookPackageUp
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPackageUp (int $packageId) {
        return self::getClass()->hookPackageUp([
            "packageId" => $packageId,
        ]);
    }

    /**
     * hookPackageUpdate
     *
     * @param  int $packageId 套餐id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPackageUpdate (int $packageId) {
        return self::getClass()->hookPackageUpdate([
            "packageId" => $packageId,
        ]);
    }

    /**
     * hookPackageDown
     *
     * @param  int $packageId 套餐id [ require true ]
     * @param  array $subPackageIds 子套餐ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookPackageDown (int $packageId, array $subPackageIds) {
        return self::getClass()->hookPackageDown([
            "packageId" => $packageId,
            "subPackageIds" => $subPackageIds,
        ]);
    }

    /**
     * hookChangeClassificationStore
     *
     * @param  int $classificationId 分组id [ require true ]
     * @param  array $storeIds 门店ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookChangeClassificationStore (int $classificationId, array $storeIds) {
        return self::getClass()->hookChangeClassificationStore([
            "classificationId" => $classificationId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * hookProductServiceGroupUpdate
     *
     * @param  int $serviceGroupId 服务组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookProductServiceGroupUpdate (int $serviceGroupId) {
        return self::getClass()->hookProductServiceGroupUpdate([
            "serviceGroupId" => $serviceGroupId,
        ]);
    }

    /**
     * hookDiscountRuleUpdate
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookDiscountRuleUpdate () {
        return self::getClass()->hookDiscountRuleUpdate();
    }

    /**
     * hookServiceUpdate
     *
     * @param  int $serviceId 服务id [ require true ]
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookServiceUpdate (int $serviceId, int $productId) {
        return self::getClass()->hookServiceUpdate([
            "serviceId" => $serviceId,
            "productId" => $productId,
        ]);
    }

    /**
     * 每天凌晨1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function cronSetCache () {
        return self::getClass()->cronSetCache();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Product', 'Cache');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Product', 'Cache');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}